<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateProduct extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
        Schema::create('myadmin_products', function($table){
            $table->increments('id');
            $table->integer('category_id')->unsigned();
            $table->string('title', 100)->nullable();
            $table->string('sub_title', 100)->nullable();
            $table->mediumText('content')->nullable();
            $table->mediumText('origin_content')->nullable();
            $table->integer('price')->unsigned();
            $table->string('img_path', 100)->nullable();
            $table->timestamps();
            $table->boolean('isActive')->default(True);
        });

        Schema::table('myadmin_products', function($table){
            $table->foreign('category_id')->references('id')->on('myadmin_product_classes')->onDelete('cascade');
        });
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
        Schema::drop('myadmin_products');
	}

}
