@extends('Myadmin::layout.basic')

@section('content')
<div class="row-fluid">
    <div class="span9">
        <h4 class="nametag">{{{ trans($_CONST["LANG_DEST"].".class_title")}}}</h4>

		<a href="{{URL::to('admin/productclass')}}" class="btn btn-success btn-custom" style="margin-top:10px">
			<span class="glyphicon glyphicon-file"></span>
			產品管理
		</a>
		<a href="{{URL::to('admin/articleclass')}}" class="btn btn-link btn-custom" style="margin-top:10px">
			<span class="glyphicon glyphicon-file"></span>
			文章管理
		</a>
		<a href="{{URL::to('admin/userclass')}}" class="btn btn-link btn-custom" style="margin-top:10px">
			<span class="glyphicon glyphicon-file"></span>
			部落客管理
		</a>
{{--
        <hr>
		<a href="#" class="btn btn-primary btn-custom store-fix" style="margin-top:10px">
			<span class="glyphicon glyphicon-file"></span>
			儲存修改
		</a>
--}}
		<hr>
        {{ Form::open(array( 'action'=>$_CONST["CONTROLLER_ROUTE"].'.store', 'class'=>'form-horizontal well'))}}
        <div class="input-group">
            <span class="input-group-addon">{{{ trans($_CONST["LANG_DEST"].".new_class_name")}}}：</span>
            {{ Form::text('title', null, array('class' => 'form-control'))}}
            <span class="input-group-btn">
                <input type="submit" href="{{ route($_CONST["CONTROLLER_ROUTE"].'.create')}}" class="btn btn-primary" value="{{{ trans($_CONST["LANG_DEST"].".class_create_action")}}}">
            </span>
        </div>
        {{ Form::close()}}
        <table class="table table-bordered">
            <tr>
                <th>分類名稱</th>
                <th class="col-md-4">操作</th>
                <th>刪除</th>
				<th>呈現</th>
            </tr>
            @foreach ($categories as $category)
                <tr data-id={{$category->id}}>
					<td>{{{ $category-> name }}}</td>
{{--
	                <td><a href="{{ action($_CONST["SUB_CONTROLLER"].'@'.'show', $category->id)}}">{{{ $category->title}}}</a></td>
--}}
                <td>
					{{ Form::model($category, array(
		    			'route' => array($_CONST["CONTROLLER_ROUTE"].'.update', $category->id),
					    'class' =>'form-horizontal',
		    			'method' => 'put'
					))}}
        	    	<div class="input-group">
			            {{ Form::text('title', '', array('class' => 'form-control'))}}
			            <span class="input-group-btn">
            		    <input type="submit" href="{{ route($_CONST["CONTROLLER_ROUTE"].'.create')}}" class="btn btn-primary" value="{{{ trans($_CONST["LANG_DEST"].".class_rename_action")}}}">
            			</span>
        			</div>
					{{ Form::close()}}
				</td>
                <td>
                    {{ Form::open(array(
                        'route'=>array($_CONST["CONTROLLER_ROUTE"].'.destroy', $category->id),
                        'method' => 'delete')
                    )}}
				<a href="#"  onclick="if (confirm('{{ trans('Myadmin::layout.whether_to_delete')}}\n注意！會連同該類別的產品一同刪除！！'))$(this).closest('form').submit()" class="btn btn-danger">
                      <span class="glyphicon glyphicon-remove"></span>
                      刪除
				</a>
{{--                    {{ Form::submit(trans($_CONST["LANG_DEST"].".class_delete_action"), array("class"=>"delete"));}}	--}}
                    {{ Form::close()}}
                </td>
				<td>
					<div class="input-group">
						@if($category->show == '1')
							{{ Form::checkbox('show', null, true, array('class' => 'form-control' , 'style' => 'width:15px')) }}
						@else
							{{ Form::checkbox('show', null, false, array('class' => 'form-control' , 'style' => 'width:15px')) }}
						@endif
					</div>
				</td>
                </tr>
            @endforeach
			<input type="hidden" value="" class="id-change"></input>
        </table>
    </div>
</div>

<script type="text/javascript" charset="utf-8">
	$(document).ready(function(){
		var c_array = [];
		var unique;
			
			$("[name=show]").change(small_change);

			// store the small changes.	
			$("[name=show]").change(function(){
				console.log("aa");
				var obj = [];
				if(unique != null){
					for (var i = 0 ; i < unique.length ; i++){
						var data = $("tr[data-id="+unique[i]+"]").children("td");//.children("[name=stock_amount]").val();
						obj.push({"id":unique[i].toString(), "checked":data.find("[name=show]").prop('checked')});
					}
					window.location = "{{ URL::to('admin/productclass/fix/')  }}" + "/" + JSON.stringify(obj);
					alert("store success !!");
				}
				else
					alert("nothing has to be stored");
			});

			function small_change(){
				var change = $(this).parents("tr").data("id");
				c_array.push(change);
				unique = c_array.filter(function(item,i,c_array){
					return i==c_array.indexOf(item);
				});
				console.log(unique);
				$(".id-change").val(unique);
			};
	});
</script>

@stop
