@extends('Myadmin::layout.basic')

@section('content')
<style type="text/css" media="screen">
	.btn-custom{  
		width: 150px;  
    } 
    .table-btn td{
        padding:10px;
    }
	.form-inline {
		margin:10px;
	}
	#bonus-form {
		text-align:center;
	}
	#bonus-form td {
		padding:10px;
	}
</style>

<div>
    <h4 class="nametag">品牌管理系統</h4>
	<hr>
		<div class="row">	
            <div class="col-xs-8 col-sm-8 col-md-8">
                <table class="table-btn">
                    <tr><td>
						<a class="btn btn-primary btn-custo" href={{URL::to('admin/product/brandcreate/1')}}>
                        <span class="glyphicon glyphicon-file"></span>
                        新增品牌
                    </a>
                    </td>
					</tr>
                </table>
			</div>
{{--
			<div class="col-md-4 col-sm-4 col-xs-4 pull-right" style="margin-top:10px">
				<div class="input-group">
					<input type="text" class="form-control" placeholder="Product's name" id="search_input">
					<span class="input-group-btn">
						<button class="btn btn-default" type="button" name="search">Seach</button>
					</span>
				</div>
			</div>
--}}
		</div>
		<hr>

    <table class="table table-bordered" id="product-table">
		<thead>
			<tr><th>商標ID</th><th>商標名稱</th><th>商標簡介</th><th>商標FB</th><th>商標IG</th><th>Follow</th><th style="width:180px">功能按鈕</th><th style="width:200px">商標圖</th></tr>
		</thead>
		<tbody>
        @foreach ($brands as $brand) 

        <tr data-id={{$brand->id}}>
                <td>{{{ $brand->id}}}</td>
                <td>{{{ $brand->name}}}</td>
                <td>{{{ $brand->description}}}</td>
                <td>{{{ $brand->facebook_url}}}</td>
                <td>{{{ $brand->instagram_url}}}</td>
                <td>{{{ $brand->follow}}}</td>
{{--            <td style="width:129px font-size:12px" id="td_pro_title">{{ $brand->name }}</td>	--}}

            <td style="width:100px font-size:12px">
                {{ Form::open(array(
                    'url'=>array('admin/product/branddestroy', $brand->id),
                    'method' => 'get')
                )}}

                <a href="{{ URL::to('admin/product/brandedit/'.$brand->id)}}" class="btn btn-primary">
                    <span class="glyphicon glyphicon-pencil"></span>
                    編輯
                </a>

                <a href="#" onclick="if (confirm('{{ trans('Myadmin::layout.whether_to_delete')}}'))$(this).closest('form').submit()" class="btn btn-danger">
                    <span class="glyphicon glyphicon-remove"></span>
                    刪除
                </a>
                {{ Form::close()}}
            </td>
			<td><a href="{{$brand->url}}" ><img src="{{{ img_upload_url($brand->img_path)}}}" style="width:200px"></a></td>	
        </tr>
        @endforeach
		<input type="hidden" value="" class="id-change"></input>
		</tbody>
    </table>
</div>

    <script type="text/javascript" charset="utf-8">
        $(document).ready(function(){
            var base_url = "{{route('admin.product.index')}}";
			var c_array = [];
			var unique;

			$("#search_input").keyup(function(){
				// When value of the input is not blank
				if( $(this).val() != ""){
				// Show only matching TR, hide rest of them
			 		$("#product-table tbody>tr").hide();
					$("#product-table #td_pro_title:contains-ci('"+$(this).val()+"')").parent("tr").show();
		 		}
		 		else{
			 		// When there is no input or clean again, show everything back
			 		$("#product-table tbody>tr").show();
		 		}
			});
        });

		$.extend($.expr[":"],
		{
			"contains-ci": function(elem, i, match, array)
			{
				return (elem.textContent || elem.innerText || $(elem).text() || "").toLowerCase().indexOf((match[3] || "").toLowerCase()) >= 0;
			}
		});
    </script>
    <style>
    </style>

@stop

