@extends('Myadmin::layout.basic')

@section('header')
<script src="{{ App::make("myadmin")->asset('/ckeditor/ckeditor.js') }}"></script>
@stop

@section('content')
<style type="text/css" media="screen">
    img#preview{
        width:150px;
        height:150px;
        padding:2px;
        border:1px solid #000;
    }
	.btn-my{  
		background: #006633;
		width: 100px;  
		height: 100px;  
		-moz-border-radius: 50%;  
		-webkit-border-radius: 50%;  
		border-radius: 50%;  
	}  
	.btn-my:hover {  
        background: #BFEC3E;   
        color:#e75616;  
    }  
</style>
<div>
    {{ Form::model($brand, array(
		'action' => array('ProductController@brandupdate', $brand->id ),
        'class'=>'form-horizontal well',
        'method' => 'post',
		'files' => true 
    ))}}

	@if($errors->has())
			<div class="alert alert-warning" role="alert">{{ $errors->first() }}</div>
	@endif

	<div name="id" class="form-control" style="display:none">{{$brand->id}}</div>
    <div class="form-group ">
        <label class="col-sm-2 control-label">商標名稱</label>
        <div class="col-sm-10">
            {{ Form::text('name', null, array('class' => 'form-control'))}}
        </div>
    </div>
    <div class="form-group ">
        <label class="col-sm-2 control-label">商標簡介</label>
        <div class="col-sm-10">
            {{ Form::textarea('description', null, array('class' => 'form-control'))}}
        </div>
    </div>
    <div class="form-group ">
        <label class="col-sm-2 control-label">商標 Facebook</label>
        <div class="col-sm-10">
            {{ Form::text('facebook_url', null, array('class' => 'form-control'))}}
        </div>
    </div>
    <div class="form-group ">
        <label class="col-sm-2 control-label">商標 Instagram</label>
        <div class="col-sm-10">
            {{ Form::text('instagram_url', null, array('class' => 'form-control'))}}
        </div>
    </div>
    <div class="form-group ">
        <label class="col-sm-2 control-label">Youtube</label>
        <div class="col-sm-10">
            {{ Form::text('youtube', null, array('class' => 'form-control'))}}
        </div>
    </div>

	<div id="update_pic">
    	<div class="form-group">
        	<label class="col-sm-2 control-label">商標照片</label>
	        <div class="col-sm-2">
			<input name="image" type="file" onchange="readURL(this,'image');">	
			@if (strlen($brand["img_path"] ) > 0)
				<img style="width:150px;height:150px" id="preview" class="image" src="{{{ img_upload_url($brand["img_path"])}}}">
			@else
				<img style="width:150px;height:150px" id="preview" class="image" src="{{ App::make("myadmin")->asset('images/photoshop.jpg') }}">
			@endif
	        </div>
{{--
        	<label class="col-sm-2 control-label">形象照片</label>
	        <div class="col-sm-2">
			<input name="photo" type="file" onchange="readURL(this,'photo');">	
			@if (strlen($brand["photo_path"] ) > 0)
				<img style="width:150px;height:150px" id="preview" class="photo" src="{{{ img_upload_url($brand["photo_path"])}}}">
			@else
				<img style="width:150px;height:150px" id="preview" class="photo" src="{{ App::make("myadmin")->asset('images/photoshop.jpg') }}">
			@endif
	        </div>	--}}
		</div>
	</div>
    <div class="form-group ">
        <label class="col-sm-2 control-label">立即買</label>
        <div class="col-sm-10">
            {{ Form::text('buynow', null, array('class' => 'form-control'))}}
        </div>
    </div>
    <div class="form-group ">
        <label class="col-sm-2 control-label">出沒地點</label>
        <div class="col-sm-10">
            {{ Form::text('location', null, array('class' => 'form-control'))}}
        </div>
    </div>
    <div class="form-group ">
        <label class="col-sm-2 control-label">官方網站</label>
        <div class="col-sm-10">
            {{ Form::text('url', null, array('class' => 'form-control'))}}
        </div>
    </div>
	<hr>

    <div class="form-group">
        <label class="col-sm-2 control-label"></label>
        <div class="col-sm-10">
        	<a href="{{{ URL::to('admin/product/brands/1')}}}" class="btn btn-success">
            	<span class="glyphicon glyphicon-arrow-left"></span>
		            {{{ trans($_CONST["LANG_DEST"].".turn_back")}}}
        	</a>
            <input type="submit" name="" value="新增商標" class="btn btn-primary"  />
        </div>
    </div>
    {{ Form::close()}}

</div>

<script type="text/javascript" charset="utf-8">
	$(document).ready(function(){
	});
		function readURL(input, name) {
//			console.log("aa");
//			console.log(name);
			if (input.files && input.files[0]) {
				var reader = new FileReader();

				reader.onload = function (e) {
					//$('.image').attr('src', e.target.result);
					$("."+name+"").attr('src', e.target.result);
				}
				reader.readAsDataURL(input.files[0]);
			}
		}

</script>


@stop

@section('js-snippet')
    @include('Myadmin::js.preview', array('bind' => 'input[name=image]','target' => '.preview'))
    @include('Myadmin::js.ckeditor', array(
        'target' => 'origin_content',
    ))
@stop



