@extends('Myadmin::layout.basic')

@section('header')
<script src="{{ App::make("myadmin")->asset('/ckeditor/ckeditor.js') }}"></script>
<script src="../../../js/bootstrap-datetimepicker.min.js" type="text/javascript"></script>
<link rel="stylesheet" href="{{asset('css/bootstrap-datetimepicker.min.css')}}" />
@stop

@section('content')
<style type="text/css" media="screen">
    img#preview{
        width:150px;
        height:150px;
        padding:2px;
        border:1px solid #000;
    }
	.btn-my{  
		background: #006633;
		width: 100px;  
		height: 100px;  
		-moz-border-radius: 50%;  
		-webkit-border-radius: 50%;  
		border-radius: 50%;  
	}  
	.btn-my:hover {  
        background: #BFEC3E;   
        color:#e75616;  
    }  
	.btn-info{
	}
</style>
<div>
    {{ Form::model($product, array(
        'route'=> array($_CONST["CONTROLLER_ROUTE"].'.update', $product->id),
        'class'=>'form-horizontal well',
        'method' => 'put',
        'files' => true
    ))}}

	@if($errors->has())
			<div class="alert alert-warning" role="alert">{{ $errors->first() }}</div>
	@endif

    <div class="form-group ">
		<label class="col-sm-2 control-label">商品類別</label>
		<div class="col-sm-10">
			{{ Form::select('category_id', $option, null, array('class' => 'form-control'))}}
		</div>
    </div>
    <div class="form-group ">
        <label class="col-sm-2 control-label">發佈</label>
        <div class="col-sm-10">
        	<div class="col-sm-1">    {{ Form::radio('publish', '1' )}}是 </div>
 	       <div class="col-sm-1">    {{ Form::radio('publish', '0', true )}}否 </div>
        </div>
    </div>
    <div class="form-group ">
        <label class="col-sm-2 control-label">商品名稱</label>
        <div class="col-sm-10">
            {{ Form::text('title', null, array('class' => 'form-control'))}}
        </div>
    </div>
    <div class="form-group ">
        <label class="col-sm-2 control-label">商品副標</label>
        <div class="col-sm-10">
			{{ Form::select('subheading', $brands, null, array('class' => 'form-control')) }}
        </div>
    </div>
    <div class="form-group ">
        <label class="col-sm-2 control-label">商品規格</label>
        <div class="col-sm-10">
            {{ Form::text('format', null, array('class' => 'form-control'))}}
        </div>
    </div>
    <div class="form-group ">
        <label class="col-sm-2 control-label">類別1(optional)</label>
        <div class="col-sm-2">
            {{ Form::text('tag_1', null, array('class' => 'form-control'))}}
        </div>
        <label class="col-sm-2 control-label">類別2(optional)</label>
        <div class="col-sm-2">
            {{ Form::text('tag_2', null, array('class' => 'form-control'))}}
        </div>
        <label class="col-sm-2 control-label">類別3(optional)</label>
        <div class="col-sm-2">
            {{ Form::text('tag_3', null, array('class' => 'form-control'))}}
        </div>
    </div>
    <div class="form-group ">
        <label class="col-sm-2 control-label">價格</label>
        <div class="col-sm-10">
            {{ Form::number('price', null, array('class' => 'form-control'))}}
        </div>
    </div>
    <div class="form-group ">
        <label class="col-sm-2 control-label">特價</label>
        <div class="col-sm-10">
            {{ Form::number('selling_price', null, array('class' => 'form-control'))}}
        </div>
    </div>

    <div class="form-group">
        <label class="col-sm-2 control-label">官網連結</label>
        <div class="col-sm-10">
            {{ Form::text('official_url', null, array('class' => 'form-control'))}}
        </div>
    </div>
	
    <div class="form-group" id="close">
        <label class="col-sm-2 control-label">上架時間</label>
		<div id="datetimepicker" class="col-sm-3 input-append date">  
    		<input type="text" name="start_date" value="{{$product->start_date}}"></input>  
	        <span class="glyphicon glyphicon-calendar add-on btn" data-time-icon="icon-time" data-date-icon="icon-calendar"></span>  
    	</div>  
    </div>

	<div id="update_shop">
    <div class="form-group ">
        <label class="col-sm-2 control-label">上架店名</label>
        <div class="col-sm-10">
			<a style="margin-top:10px" data-toggle="modal" data-target="#snModal">
				{{ Form::text('shop_name' , null , array('class' => 'form-control') ) }}
			</a>
        </div>
        <div class="col-sm-10" style="display:none">
			<a style="margin-top:10px">
				{{ Form::text('shops_id' , null , array('class' => 'form-control') ) }}
			</a>
        </div>
    </div>
	</div>
	
	<div id="update_pic">
	@for ($i=0 ; $i < count($detail) ; $i++)
	<div class="form-group" data-id={{$detail[$i]['id']}}>
		<label class="col-sm-2 control-label">圖片上傳區</label>
		<div class="col-sm-2">
			<input name='image[]' type="file" onchange="readURL(this, {{$i}})"></input>
{{--			{{ Form::file('image'.$i , array('onchange' => 'readURL(this, $i)'))}}	--}}
			@if (strlen($product["image".$i] ) > 0)
				<img style="width:150px;height:150px" id="preview" class="image{{$i}}" src="{{{ img_upload_url($product["image".$i])}}}">
			@else
				<img style="width:150px;height:150px" id="preview" class="image{{$i}}" src="{{ App::make("myadmin")->asset('images/photoshop.jpg') }}">
			@endif
		</div>
		<hr>
		{{Form::hidden('id'.$i, $detail[$i]['id'], array('class' => 'form-control'))}}
		<div class="col-sm-5">
			Name :
			{{Form::text('img_title[]', $detail[$i]['img_title'], array('class' => 'form-control'))}}	
		</div>
		<div class="col-sm-5">
			Contents : 
			{{Form::textarea('img_description[]', $detail[$i]['img_description'], array('class' => 'form-control' , 'style' => 'height:60px'))}}	
		</div>
		<button type="button" id="btnminus{{$i}}" class="btn btn-my glyphicon glyphicon-minus"></button>
	</div>
	
	@endfor

	</div>
	<button type="button" id="btnplus" class="btn btn-my glyphicon glyphicon-plus" style="margin-left:50%"></button>
	<hr>
    <div class="form-group ">
        <label class="col-sm-2 control-label">商品描述</label>
        <div class="col-sm-10">
            {{ Form::textarea('description', null, array('class' => 'input-xxlarge form-control ckeditor'))}}		{{--origin_content -> description--}}
        </div>
    </div>
    <hr>
    <div class="form-group">
        <label class="col-sm-2 control-label"></label>
        <div class="col-sm-10">
            <input type="submit" name="" value="編輯完成" class="btn btn-primary"  />
        </div>
    </div>
    {{ Form::close()}}

	<!-- Modal -->
	<div id="snModal" class="modal fade" role="dialog">
		<div class="modal-dialog">
		<!-- Modal content-->
			<div class="modal-content">
				<div class="modal-header">
					<button type="button" class="close" data-dismiss="modal">&times;</button>
					<h4 class="modal-title">店家</h4>
				</div>
				<div class="modal-body">
					@foreach ($shopname as $shop)
						@if($shop == "全選")
							{{ Form::checkbox('shopname', $shop , false, ['onClick' => 'checkall()']) }} 
							{{ $shop }} &nbsp&nbsp&nbsp
						@else
							{{ Form::checkbox('shopname', $shop , false) }} 
							{{ $shop }} &nbsp&nbsp&nbsp
						@endif	
					@endforeach
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-default" data-dismiss="modal" id="shopclose">確定</button>
				</div>
			</div>
		</div>
	</div>

	<!-- Modal -->
	<div id="wsModal" class="modal fade" role="dialog">
		<div class="modal-dialog">
		<!-- Modal content-->
			<div class="modal-content">
				<div class="modal-header">
					<button type="button" class="close" data-dismiss="modal">&times;</button>
					<h4 class="modal-title">區域</h4>
				</div>
				<div class="wsmodal-body">
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-default" data-dismiss="modal">確定</button>
				</div>
			</div>
		</div>
	</div>
</div>

<script type="text/javascript">
	$(function() {
		$("#datetimepicker").datetimepicker({
			language: 'en',
			pickTime: 'true',
			format: 'yyyy-MM-dd hh:mm:ss'
		});
	});
</script>
<script type="text/javascript" charset="utf-8">
	$(document).ready(function(){
		var count_pic = {{count($detail)}};
		var count_shop = 0;

		/* adding for images */
		$("#btnplus").click(function(){
			var str = '<div class="form-group id="pic'+count_pic+'"> <label class="col-sm-2 control-label">圖片上傳區</label> <div class="col-sm-2"> <input name="image[]" type="file" onchange="readURL(this, '+count_pic+')"><img style="width:150px;height:150px" class="preview image'+count_pic+'" src="{{ App::make("myadmin")->asset('images/photoshop.jpg') }}"> </div> <hr> <input class="form-control" name="id'+count_pic+'" type="hidden" value="-1"> <div class="col-sm-5"> Name : <input class="form-control" name="img_title[]" type="text"> </div> <div class="col-sm-5"> Contents : <textarea class="form-control" name="img_description[]" style="height:60px"></textarea> </div> <button type="button" id="btnminus'+count_pic+'" class="btn btn-my glyphicon glyphicon-minus"></button> </div> ';
   
			$("#update_pic").append(str);
			count_pic++;
			$(".glyphicon-minus").click(function(){
				if ( confirm('是否刪除此圖片?') ){
					$(this).parent().remove();
				}
			});
		});

		$(".glyphicon-minus").click(function(){
			if ( confirm('是否刪除此圖片?') ){
				$(this).parent().remove();
				var id = $(this).parent(".form-group").data("id");
	//			console.log(id);
//				console.log({{$product->id}});
				window.location = "{{ URL::to('admin/product/imgdelete') }}" + '/' + id + '/' + "{{$product->id}}";
			}
		});

		var optarr = {{$address}};
		console.log(optarr);

		/* choosing shops */
		var shopid = $("input[name=shops_id]").val().split(",");
		$("input[name=shopname]").on('click', function(){
			console.log($(this).val());
			if($(this).val() == "全選")
				shopid = [];
			$(".wsmodal-body").empty();
			if($(this).is(":checked")){
				var str = "<input type='checkbox' name='shopregion' value='全選' onclick=checklist() >全選&nbsp&nbsp&nbsp</input>";
				for(var i=0 ; i<optarr.length ; i++){
					if($(this).val() == optarr[i]['name']){
						str += "<input type='checkbox' name='shopregion' value=" + optarr[i]['region'] + " data-id=" + optarr[i]['id'] + ">"+ optarr[i]['region'] +"&nbsp&nbsp&nbsp</input>";
					}
					if($(this).val() == "全選")
						shopid.push(optarr[i]['id']);
				}

				if($(this).val() == "全選"){
					$("input[name=shops_id]").val(shopid);	
				}
				else{
					$(".wsmodal-body").append(str);
					$("#wsModal").modal('show');
				}
			}
			else{
				shopid = [];
				if($(this).val() == "全選"){
					$("input[name=shops_id]").val(shopid);	
				}
				else{
					$("input[value=全選]").prop("checked", false);
					for(var i=0 ; i<optarr.length ; i++){
						if($("input[value=" + optarr[i]['name'] + "]").is(":checked")){
							shopid.push(optarr[i]['id']);
						}
					}
					$("input[name=shops_id]").val(shopid);	
				}
			}

				$("input[name=shopregion]").on('click', function(){
					if($(this).is(":checked")){
						if($(this).val() == "全選"){
							var dataList = $("input[name=shopregion]").parent('div').children('input[data-id]').map(function() {
								shopid.push($(this).data("id"));
								return $(this).data("id");
							}).get();
						}
						else
							shopid.push($(this).data("id"));
					}
					else if($(this).is(":checked") == false){
						$("input[value=全選]").prop("checked", false);
						if($(this).val() == "全選"){
							var dataList = $("input[name=shopregion]").parent('div').children('input[data-id]').map(function() {
								var index = shopid.indexOf($(this).data("id"));
								if(index > -1)
									shopid.splice(index, 1);
								return $(this).data("id");
							}).get();
						}
						else{
							var index = shopid.indexOf($(this).data("id"));
							if(index > -1)
								shopid.splice(index, 1);
						}
					}
					var unique = shopid.filter(function(itm, i, shopid){
						return i==shopid.indexOf(itm);
					});
			//		console.log(shopid);
		//			console.log(unique);
					shopid = unique;
					$("input[name=shops_id]").val(unique);
				});
		});
		
		/* transform shop id to shop name. */
		if($("input[name=shops_id]").val()){
			var shopid = $("input[name=shops_id]").val().split(",");
			var str = "";
			console.log(shopid);
			for(var i = 0 ; i<shopid.length ; i++){
				for(var j = 0 ; j<optarr.length ; j++){
					if(optarr[j]['id'] == shopid[i]){
						$("input[value=" + optarr[j]['name'] + "]").prop('checked', true);
						str += optarr[j]['name']+"-"+optarr[j]['region']+" , ";
						console.log(optarr[j]['name']+" - "+optarr[j]['region']);
						break;
					}
				}
			}
			$("input[name=shop_name]").val(str);
		}

		$("#shopclose").click(function(){
			if($("input[name=shops_id]").val()){
				var shopid = $("input[name=shops_id]").val().split(",");
				var str = "";
				console.log(shopid);
				for(var i = 0 ; i<shopid.length ; i++){
					for(var j = 0 ; j<optarr.length ; j++){
						if(optarr[j]['id'] == shopid[i]){
							$("input[value=" + optarr[j]['name'] + "]").prop('checked', true);
							str += optarr[j]['name']+"-"+optarr[j]['region']+" , ";
							break;
						}
					}
				}
				$("input[name=shop_name]").val(str);
			}
		});
	});

	function checkall(){
		if($("input[value=全選]").is(":checked") == true)
			$("input[name=shopname]").prop('checked', true);
		else			
			$("input[name=shopname]").prop('checked', false);
	};
1
	function checklist(){
	if($("input[value=全選]").is(":checked") == true)
			$("input[name=shopregion]").prop('checked', true);
		else
			$("input[name=shopregion]").prop('checked', false);
	}
	
	function readURL(input, num) {
		console.log("aa");
		if (input.files && input.files[0]) {
			var reader = new FileReader();
	
			reader.onload = function (e) {
//		console.log(num);
//		console.log(e.target.result);
				$('.image'+num).attr('src', e.target.result);
			}
			reader.readAsDataURL(input.files[0]);
		}
	}
</script>
@stop

@section('js-snippet')
    @include('Myadmin::js.preview', array('bind' => 'input[name=image]','target' => '#preview'))
    @include('Myadmin::js.ckeditor', array(
        'target' => 'origin_content',
    ))
@stop
