@extends('Myadmin::layout.basic')

@section('content')
<style type="text/css" media="screen">
	.btn-custom{  
		width: 150px;  
	}  
</style>

<div>
    <div class="input-prepend input-append">
    </div>
    <h4 class="nametag">{{{ trans($_CONST["LANG_DEST"].".title")}}}</h4>
	<br><br><br>
    {{ Form::open(array(  'class'=>'form-horizontal well'))}}
    <div class="input-group">
        <span class="input-group-addon">{{{ trans($_CONST["LANG_DEST"].".select_class")}}}：</span>
        {{ Form::select('id', $categories, 0, array('class' => 'form-control') )}}
    </div>
    {{ Form::close()}}
	<hr>
		<div class="row">	
			<div class="col-md-5">
				<a href="{{ route($_CONST["CONTROLLER_ROUTE"].'.create')}}" class="btn btn-primary btn-custom" style="margin-top:10px">
					<span class="glyphicon glyphicon-file"></span>
						新增一般商品
				</a>
				<a href="{{ route('admin.product.create', 'id=1')}}" class="btn btn-primary btn-custom" style="margin-top:10px">
					<span class="glyphicon glyphicon-file"></span>
					新增集量商品
				</a>
				<a href="{{ route('admin.product.create', 'id=2')}}" class="btn btn-primary btn-custom" style="margin-top:10px">
					<span class="glyphicon glyphicon-file"></span>
					新增限時商品
				</a>
    	    	<a href="#" class="btn btn-primary btn-custom store-fix" style="margin-top:10px">
        	    	<span class="glyphicon glyphicon-file"></span>
	            	儲存修改
		        </a>
    		    <a href="" class="btn btn-primary btn-custom" style="margin-top:10px">
        		    <span class="glyphicon glyphicon-file"></span>
            		入倉
		        </a>
    		    <a href="" class="btn btn-primary btn-custom" style="margin-top:10px">
        		    <span class="glyphicon glyphicon-file"></span>
            		出倉
		        </a>
			</div>

			{{-- Notification that number of products in warehouse is smaller than stock threshold!! --}}
{{--			<div class="dropdown col-sm-2">
		        <button class="btn btn-warning btn-custom" type="button" data-toggle="dropdown" aria-expanded="true" title="最大數量小於最低水位的通知">
    	    	    <span class="glyphicon glyphicon-bell"></span>
					{{{ trans($_CONST["LANG_DEST"].".notification") }}}
				</button>
				<ul class="dropdown-menu" role="menu" aria-labelledby="dropdownMenu1">
					@foreach ($notifications as $noti)
						<li role="presentation" ><a role="menuitem" tabindex="-1" href="#" class="noti_list" value="testvalue">{{ $noti }}</a></li>
					@endforeach	
				</ul>
			</div>
--}}
			<div class="col-md-4 col-sm-4 pull-right" style="margin-top:10px">
				<div class="input-group">
					<input type="text" class="form-control" placeholder="Product's name" id="search_input">
					<span class="input-group-btn">
						<button class="btn btn-default" type="button" name="search">Seach</button>
					</span>
				</div>
			{{-- Notification that number of products in warehouse is smaller than stock threshold!! --}}
			<div class="dropdown pull-right">
		        <button class="btn btn-warning btn-custom" style="margin-top:10px" type="button" data-toggle="dropdown" aria-expanded="true" title="最大數量小於最低水位的通知">
    	    	    <span class="glyphicon glyphicon-bell"></span>
					{{{ trans($_CONST["LANG_DEST"].".notification") }}}
				</button>
				<ul class="dropdown-menu" role="menu" aria-labelledby="dropdownMenu1">
					@foreach ($notifications as $noti)
						<li role="presentation" ><a role="menuitem" tabindex="-1" href="#" class="noti_list" value="testvalue">{{ $noti }}</a></li>
					@endforeach	
				</ul>
			</div>
			</div>
		</div>
{{--
        <a href="{{ route($_CONST["CONTROLLER_ROUTE"].'.create')}}" class="btn btn-primary">
            <span class="glyphicon glyphicon-file"></span>
            {{{ trans($_CONST["LANG_DEST"].".create_action")}}}
        </a>
        <a href="{{ action($_CONST["CLASS_CONTROLLER"].'@index')}}" class="btn btn-success">
            <span class="glyphicon glyphicon-plus"></span>
			{{{ trans($_CONST["LANG_DEST"].".manage_class") }}}
        </a>
--}}
    <hr>
    <table class="table table-bordered" id="product-table">
		<thead>
			<tr><th>商品分類</th><th>商品編號</th><th>商品名稱</th><th>商品條件</th><th>商品定價</th><th>商品售價</th><th style="width:100px">架上數量/許可數量</th><th style="width:80px">最大數量</th><th style="width:125px">特殊條件</th><th>紅利類別</th><th style="width:100px">商品顯示</th><th style="width:100px">商品狀態</th><th style="width:180px">功能按鈕</th></tr>
		</thead>
		<tbody>
        @foreach ($products as $product) 
        <tr data-id={{$product->id}} >
	    	<td style="width:129px font-size:12px">{{ $categories[$product->category_id] }}</td>
            <td style="width:129px font-size:12px">{{ $product->product_code }}</td>
            <td style="width:129px font-size:12px" id="td_pro_title">{{ $product->title }}</td>
            <td style="width:129px font-size:12px">{{ $product->format }}</td>
		    <td style="width:100px font-size:12px">{{ $product->price }}</td>
            <td style="width:129px font-size:12px">{{ $product->selling_price }}</td>
		    <td style="width:100px font-size:12px">{{ Form::text('available_amount', $product->available_amount, array('class' => 'form-control'))}}/{{ $product->stock_amount }}</td>
		    <td style="width:100px font-size:12px">{{ Form::text('stock_amount', $product->stock_amount, array('class' => 'form-control'))}}</td>
		    <td style="width:150px font-size:12px">{{ Form::select('special_case', array('無' => '無', '限量商品' => '限量商品', '熱銷商品' => '熱銷商品') , $product->special_case, array('class' => 'form-control' ))}}</td>
		    <td style="width:100px font-size:12px">{{ $bonusoption[$product->bonus_category_id] }}</td>
		    <td style="width:150px font-size:12px">{{ Form::select('is_available', array('上架' => '上架', '下架' => '下架') , $product->is_available, array('class' => 'form-control'))}}</td>
			<td style="width:100px font-size:12px">{{ $product->type }}
			<?php 
				if($product->type == '集量商品'){
		    		echo "<br><{$product->deal_baseline}></td>";
				}
				else if($product->type == '限時商品'){
		    		echo "<br>{$product->close_date}</td>";
				}
			?>

            <td style="width:100px font-size:12px">
                {{ Form::open(array(
                    'route'=>array('admin.product.destroy', $product->id),
                    'method' => 'delete')
                )}}
                <a href="#" onclick="AddOperating('{{$product->is_available}}','{{$product->available_amount}}','{{$product->stock_amount}}','{{$product->id}}');" class="btn btn-primary">
                    <span class="glyphicon glyphicon-pencil"></span>
                    操作
                </a>
                <a href="#" onclick="Broadcast()" class="btn btn-primary">
                    <span class="glyphicon glyphicon-pencil"></span>
                    推播
                </a>
                <a href="{{ route('admin.product.edit', $product->id)}}" class="btn btn-primary">
                    <span class="glyphicon glyphicon-pencil"></span>
                    編輯
                </a>

                <a href="#" onclick="if (confirm('{{ trans('Myadmin::layout.whether_to_delete')}}'))$(this).closest('form').submit()" class="btn btn-danger">
                    <span class="glyphicon glyphicon-remove"></span>
                    刪除
                </a>
                {{ Form::close()}}
            </td>

{{--			<td><img src="{{{ img_upload_url($product->img_path)}}}" width="200px"></td>	--}}
        </tr>
        @endforeach
		<input type="hidden" value="" class="id-change"></input>
		</tbody>
    </table>
    <div class="pagination">
        {{ $products->links()}}
    </div>

	<script type="text/javascript" charset="utf-8">
		function AddOperating(status,aAmount,sAmount,id){
			console.log(id);
			var allow = sAmount-aAmount;
			var str = "補貨操作 \n商品狀態 : " + status + "\n倉儲數量 : " + sAmount + "\n入倉數量 ?";//上架數量 : " + aAmount + " / " + sAmount + "\n許可數量 : " + allow;
			var add = prompt(str,'');
			if(!isNaN(add)){
                var addurl = "{{ URL::to('admin/product/addproduct') }}"; 	
				window.location = addurl + '/' + id + '/' + add;
			}
			else
				alert("Not a number!!");
		};
		function Broadcast(){
			var uploadcast = confirm("上架通知?");
			if(uploadcast)
				alert("上架通知!");
			var editcast = confirm("調整通知?");
			if(editcast)
				alert("調整通知!");
		}
	</script>

    <script type="text/javascript" charset="utf-8">
				
        $(document).ready(function(){
            var base_url = "{{route('admin.product.index')}}";
			var c_array = [];
			var unique;

			/* select class to redirect the pages */
            $("select[name=id]").change(function(){
                var t = $("select[name=id]").val();
                var base_url = "{{ route($_CONST["CONTROLLER_ROUTE"].".index")}}";
                if (t==0) {
                    var target = base_url;
                }else {
                    var target = base_url + '/' + t;
                }
                window.location = target;
            });

			$("#search_input").keyup(function(){
				// When value of the input is not blank
				if( $(this).val() != ""){
				// Show only matching TR, hide rest of them
					console.log($(this).val());
			 		$("#product-table tbody>tr").hide();
					$("#product-table #td_pro_title:contains-ci('"+$(this).val()+"')").parent("tr").show();
		 		}
		 		else{
			 		// When there is no input or clean again, show everything back
			 		$("#product-table tbody>tr").show();
		 		}
			});

			$(".noti_list").click(function(){
				console.log("test noti!!");
				console.log($(this).text());
				if( $(this).text() != ""){
				// Show only matching TR, hide rest of them
			 		$("#product-table tbody>tr").hide();
					$("#product-table #td_pro_title:contains-ci('"+$(this).text()+"')").parent("tr").show();
		 		}
		 		else{
			 		// When there is no input or clean again, show everything back
			 		$("#product-table tbody>tr").show();
		 		}
			});
	
			$("[name=available_amount], [name=stock_amount]").keyup(small_change);
			$("[name=special_case], [name=is_available]").change(small_change);
			
			$(".store-fix").click(function(){
				var obj = [];
				for (var i = 0 ; i < unique.length ; i++){
					var data = $("tr[data-id="+unique[i]+"]").children("td");//.children("[name=stock_amount]").val();
					console.log(data);
					obj.push({"id":unique[i].toString(), "available_amount":data.children("[name=available_amount]").val(), "stock_amount":data.children("[name=stock_amount]").val(), "special_case":data.children("select[name=special_case]").val(), "is_available":data.children("select[name=is_available]").val()});
					console.log(obj);
				}
				window.location = "{{ URL::to('admin/product/fix/') }}" + "/" + JSON.stringify(obj);
			});

			function small_change(){
				var change = $(this).parents("tr").data("id");
				c_array.push(change);
				unique = c_array.filter(function(item,i,c_array){
					return i==c_array.indexOf(item);
				});
//				console.log(unique);
				$(".id-change").val(unique);
			};

		});

		$.extend($.expr[":"],
		{
			"contains-ci": function(elem, i, match, array)
			{
				return (elem.textContent || elem.innerText || $(elem).text() || "").toLowerCase().indexOf((match[3] || "").toLowerCase()) >= 0;
			}
		});
    </script>
</div>
@stop


