@extends('Myadmin::layout.basic')

@section('header')
<script src="../../../js/bootstrap-datetimepicker.min.js" type="text/javascript"></script>
<script src="../../../js/Export-Html-Table-To-Excel-Spreadsheet-using-jQuery-table2excel/src/jquery.table2excel.js"></script>
<link rel="stylesheet" href="{{asset('css/bootstrap-datetimepicker.min.css')}}" />
@stop

@section('content')
<style type="text/css" media="screen">
	.btn-custom{  
		width: 150px;  
    } 

    .table-btn td{
        padding:10px;
    }
        #header {
            background:#8d1c22;
        }

        .form-inline {
            margin:10px;
        }

        #bonus-form {
            text-align:center;
        }
        
        #bonus-form td {
            padding:10px;
        }
</style>

    <div class="input-prepend input-append">
    </div>
    <h4 class="nametag">{{{ trans($_CONST["LANG_DEST"].".title")}}}</h4>
	<hr>

		<div class="row">	
            <div class="col-xs-8 col-sm-8 col-md-8">
                <table class="table-btn">
                    <tr><td>
        				<label class="col-sm-2 control-label">日期範圍</label>
						<div id="datetimepicker1" class="col-sm-3 input-append date" style="width:40%">  
		    				<input type="text" name="from_date"></input>  
	    		    		<span class="glyphicon glyphicon-calendar add-on btn" data-time-icon="icon-time" data-date-icon="icon-calendar"></span>  
		    			</div>
						<div id="datetimepicker2" class="col-sm-3 input-append date" style="width:40%">  
    						<input type="text" name="to_date"></input>  
	        				<span class="glyphicon glyphicon-calendar add-on btn" data-time-icon="icon-time" data-date-icon="icon-calendar"></span>  
				    	</div>
					</td></tr>
					<tr><td>
		        		<label class="col-sm-2 control-label">付款狀態</label>
                        <div class="col-sm-6">
                            <!-- order hide in javascript -->
							{{ Form::select('status', $statusoption, '', array('class' => 'form-control' , 'id' => 'activities_avail'))}}
						</div>
					</tr>
                </table>
			</div>

			<div class="col-md-4 col-sm-4 col-xs-4 pull-right" style="margin-top:10px">
				<div class="input-group">
					<input type="text" class="form-control" placeholder="訂單編號 , email" id="search_input">
					<span class="input-group-btn">
						<button class="btn btn-default" type="button" id="search">Seach</button>
					</span>
				</div>
				<hr>
				<div class="input-group">
					<span class="input-group-btn">
						<button class="btn btn-success" type="button" id="download">下載EXCEL報表</button>
					</span>
				</div>
			</div>

		</div>
		<hr>

    <table class="table table-bordered" id="product-table">
		<thead>
			<tr><th>訂單編號</th><th>訂單狀態</th><th>使用者</th><th>金額</th><th>商品</th><th>數量</th><th style="width:180px">功能按鈕</th></tr>
		</thead>
		<tbody>
        @foreach ($transactions as $transaction) 
        <tr data-id={{$transaction->id}}>
            <td style="width:129px font-size:12px" id="td_pro_title">{{ $transaction->order_code }}</td>
            <td style="width:129px font-size:12px" id="td_pro_status">{{ $transaction->status }}</td>
            <td style="width:129px font-size:12px" id="td_pro_email">{{ $transaction->mail }}</td>
		    <td style="width:100px font-size:12px">{{ $transaction->money }}</td>
		    <td style="width:100px font-size:12px">{{ $transaction->detail }}</td>
		    <td style="width:100px font-size:12px">{{ $transaction->amount }}</td>

            <td style="width:100px font-size:12px" class="noExl">
                {{ Form::open(array(
                    'url'=>array('admin/product/shopdestroy', $transaction->id),
                    'method' => 'get')
                )}}
                <a href="" class="btn btn-primary" data-toggle="modal" data-target="#wsModal" name="edit">
                    <span class="glyphicon glyphicon-pencil"></span>
                    編輯
                </a>
                {{ Form::close()}}
            </td>

        </tr>
        @endforeach
		<input type="hidden" value="" class="id-change"></input>
		</tbody>
    </table>

	<!-- Modal -->
	<div id="wsModal" class="modal fade" role="dialog">
		<div class="modal-dialog">

		<!-- Modal content-->
			<div class="modal-content">
				<div class="modal-header">
					<button type="button" class="close" data-dismiss="modal">&times;</button>
					<h4 class="modal-title">修改數量</h4>
				</div>
				<div class="modal-body">
					<div class="form-group">
						<label class="control-label col-sm-2">原本數量</label>
						<div class="col-sm-4">
							{{ Form::label('amount', ' ', array('class' => 'form-control' , 'id' => 'amountid'))}}
						</div>
					</div> <br><br>
					<div class="form-group">
						<label class="control-label col-sm-2">修改數量</label>
						<div class="col-sm-4">
							{{ Form::number('fix_amount', ' ', array('class' => 'form-control' , 'id' => 'fix_amount'))}}
						</div>
					</div> <br><br>
				</div>
				<div class="modal-footer">
					<button class="btn btn-success" id="amount_submit" data-dismiss="modal">submit</button>
					<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
				</div>
			</div>

		</div>
	</div>

    <script type="text/javascript" charset="utf-8">
        $(document).ready(function(){
            var base_url = "{{route('admin.product.index')}}";
			var c_array = [];
			var id;
			var transactions = {{ $transactions }};

            $("#search").click(function(){
				console.log("test");
				var from = $("input[name=from_date]").val();
				var to = $("input[name=to_date]").val();
                console.log(transactions);
			 	$("#product-table tbody>tr").hide();
                for (var i=0 ; i<transactions.length ; i++){
                    var time = transactions[i]['date'].split(" ")[0];
                    if(from == "") {
                        if(time <= to) {
                            $("tr[data-id="+transactions[i]['id']+"]").show();
                        }
                    } else if(to == "") {
                        if(time >= from) {
                            $("tr[data-id="+transactions[i]['id']+"]").show();
                        }
                    } else if(to == "" && from == "") {
                        $("tr[data-id="+transactions[i]['id']+"]").show();
                    } else if(time >= from && time <= to) {
                        $("tr[data-id="+transactions[i]['id']+"]").show();
                    }
				}
            });

            $("select[name=status]").change(function(){
				if($("select[name=status] option:selected").text() == "全部狀態")
					$("#product-table tbody>tr").show();
				else
				{
					$("#product-table tbody>tr").hide();
					$("#product-table #td_pro_status:contains-ci('"+$("select[name=status] option:selected").text()+"')").parent("tr").show();
				}
            });

			$("#search_input").keyup(function(){
				// When value of the input is not blank
				if( $(this).val() != ""){
				// Show only matching TR, hide rest of them
			 		$("#product-table tbody>tr").hide();
					$("#product-table #td_pro_title:contains-ci('"+$(this).val()+"')").parent("tr").show();
					$("#product-table #td_pro_email:contains-ci('"+$(this).val()+"')").parent("tr").show();
		 		}
		 		else{
			 		// When there is no input or clean again, show everything back
			 		$("#product-table tbody>tr").show();
		 		}
			});

			$("a[name=edit]").click(function(){
				id = $(this).closest("tr").data("id");
				for (var i=0 ; i<transactions.length ; i++){
					if(transactions[i]['id'] == $(this).closest("tr").data("id"))
						$("#amountid").text(transactions[i]['amount']);
				}
			});

			$("#amount_submit").click(function(){
				window.location = "{{ URL::to('admin/product/instock') }}" + "/" + id + "/" + $("#fix_amount").val();
			});

			$("#download").click(function() {
				$("#product-table").table2excel({
					exclude: $("tr:hidden"),
					name: "Excel Document Name",
					filename: "reports"
				});
			});

        });

        $("#activities_avail option").each(function(){
            if($(this).val() == "0" || $(this).val() == "1"|| $(this).val() == "2") {
            }else {
                $(this).hide();
            }  
        });

		$("#datetimepicker1, #datetimepicker2").datetimepicker({
			language: 'en',
			pickTime: true,
			pickDate: true,
			format: 'yyyy-MM-dd',
		});

		$.extend($.expr[":"],
		{
			"contains-ci": function(elem, i, match, array)
			{
				return (elem.textContent || elem.innerText || $(elem).text() || "").toLowerCase().indexOf((match[3] || "").toLowerCase()) >= 0;
			}
		});
    </script>
@stop

