@extends('Myadmin::layout.basic')

@section('content')
<style type="text/css" media="screen">
	.btn-custom{  
		width: 150px;  
    } 

    .table-btn td{
        padding:10px;
    }
        #header {
            background:#8d1c22;
        }

        .form-inline {
            margin:10px;
        }

        #bonus-form {
            text-align:center;
        }
        
        #bonus-form td {
            padding:10px;
        }

    .suggest-name {
        display:none;
    }
    .suggest {
        cursor:pointer;
    }

    .suggest:hover {
        color:orange;
    }
</style>

    <div class="input-prepend input-append">
    </div>
    <h4 class="nametag">實體店管理系統</h4>
	<hr>

		<div class="row">	
            <div class="col-xs-8 col-sm-8 col-md-8">
                <table class="table-btn">
                    <tr><td>
                    <a class="btn btn-primary btn-custom" style="margin-top:10px" data-toggle="modal" data-target="#wsModal">
                        <span class="glyphicon glyphicon-file"></span>
                        新增實體店
                    </a>
                    </td></tr>
                </table>
			</div>

			<div class="col-md-4 col-sm-4 col-xs-4 pull-right" style="margin-top:10px">
				<div class="input-group">
					<input type="text" class="form-control" placeholder="Product's name" id="search_input">
					<span class="input-group-btn">
						<button class="btn btn-default" type="button" name="search">Seach</button>
					</span>
				</div>
			</div>
		</div>
		<hr>

    <table class="table table-bordered" id="product-table">
		<thead>
			<tr><th>店ID</th><th>店名</th><th>地址</th><th>經緯度</th><th style="width:180px">功能按鈕</th></tr>
		</thead>
		<tbody>
        @foreach ($shops as $shop) 
        <tr data-id={{$shop->id}}>
            <td style="width:129px font-size:12px">{{ $shop->id }}</td>
            <td style="width:129px font-size:12px" id="td_pro_title">{{ $shop->name }}({{$shop->region}})</td>
            <td style="width:129px font-size:12px">{{ $shop->address }}</td>
		    <td style="width:100px font-size:12px">{{ $shop->position_x }},{{$shop->position_y}}</td>

            <td style="width:100px font-size:12px">
                {{ Form::open(array(
                    'url'=>array('admin/product/shopdestroy', $shop->id),
                    'method' => 'get')
                )}}
                <a href="{{ URL::to('admin/product/shopedit/'.$shop->id)}}" class="btn btn-primary">
                    <span class="glyphicon glyphicon-pencil"></span>
                    編輯
                </a>

                <a href="#" onclick="if (confirm('{{ trans('Myadmin::layout.whether_to_delete')}}'))$(this).closest('form').submit()" class="btn btn-danger">
                    <span class="glyphicon glyphicon-remove"></span>
                    刪除
                </a>
                {{ Form::close()}}
            </td>

        </tr>
        @endforeach
		<input type="hidden" value="" class="id-change"></input>
		</tbody>
    </table>

	<!-- Modal -->
	<div id="wsModal" class="modal fade" role="dialog">
		<div class="modal-dialog">

		<!-- Modal content-->
			<div class="modal-content">
				<div class="modal-header">
					<button type="button" class="close" data-dismiss="modal">&times;</button>
					<h4 class="modal-title">新增實體店</h4>
				</div>
				<div class="modal-body">
					<div class="form-group">
						<label class="control-label col-sm-2">店名</label>
						<div class="col-sm-4">
							{{ Form::text('name', '', array('class' => 'form-control' , 'id' => 'td_pro_title'))}}
						</div>
					</div> <br><br>
					<div class="form-group">
						<label class="control-label col-sm-2">區域</label>
						<div class="col-sm-4">
                            {{ Form::text('region', '', array('class' => 'form-control'))}}
                        </div>
					</div> <br><br>
					<div class="form-group">
						<label class="control-label col-sm-2">地址</label>
						<div class="col-sm-4">
							{{ Form::text('address', '', array('class' => 'form-control' , 'id' => 'inproduct_title'))}}
						</div>
                        <div class="col-sm-2 suggest-name">建議：</div>
                        <div class="col-sm-4 suggest"></div>
					</div> <br><br>
					<div class="form-group">
						<label class="control-label col-sm-2">經度</label>
						<div class="col-sm-4">
							{{ Form::number('position_x', '', array('class' => 'form-control' , 'id' => 'inproduct_format'))}}
						</div>
					</div> <br><br>
					<div class="form-group">
						<label class="control-label col-sm-2">緯度</label>
						<div class="col-sm-4">
							{{ Form::number('position_y', '', array('class' => 'form-control' , 'id' => 'inproduct_stocknum'))}}
						</div>
					</div> <br><br>
				</div>
				<div class="modal-footer">
					<button class="btn btn-success" id="shop_submit" data-dismiss="modal">submit</button>
					<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
				</div>
			</div>

		</div>
	</div>

    <script type="text/javascript" charset="utf-8">
        $(document).ready(function(){
            var base_url = "{{route('admin.product.index')}}";
			var c_array = [];
			var unique;

            $("#search").click(function(){
                var redirect = base_url+'/'+$("input[name=search]").val();
                window.location.href = redirect;
            });

            $("select[name=id]").change(function(){
                var t = $("select[name=id]").val();
                var base_url = "{{ route("admin.product.index")}}";
                if (t==0) {
                    var target = base_url;
                }else {
                    var target = base_url + '/' + t;
                }
                window.location = target;
            });

            $("#inproduct_title").keyup(function(){
                if($(this).val() == "") {
                    $("[name=position_x]").val("");
                    $("[name=position_y]").val("");
                }
                var obj = getLocation($(this).val());
                obj.success(function (data) {
                    if(data["status"] == "OK") {
                        var format = data["results"][0]["formatted_address"];
                        $(".suggest-name").show();
                        $(".suggest").html(format);
                        var location = data["results"][0]["geometry"]["location"];
                        $("[name=position_x]").val(location["lat"]);
                        $("[name=position_y]").val(location["lng"]);
                    } else {
                        $(".suggest-name").hide();
                    }
                });
            });

            $(".suggest").click(function(){
                $("#inproduct_title").val($(".suggest").html());
            });

			$("#search_input").keyup(function(){
				// When value of the input is not blank
				if( $(this).val() != ""){
				// Show only matching TR, hide rest of them
			 		$("#product-table tbody>tr").hide();
					$("#product-table #td_pro_title:contains-ci('"+$(this).val()+"')").parent("tr").show();
		 		}
		 		else{
			 		// When there is no input or clean again, show everything back
			 		$("#product-table tbody>tr").show();
		 		}
			});


			/* create new shop. */
			$("#shop_submit").click(function(){
				console.log("test");
				var obj = [];
				obj.push({"name":$("input[name=name]").val(), "region":$("input[name=region]").val(), "address":$("input[name=address]").val(), "position_x":$("input[name=position_x]").val(), "position_y":$("input[name=position_y]").val() });
				window.location = "{{ URL::to('admin/product/shopstore') }}" + "/" + JSON.stringify(obj);

			});
        });

		$.extend($.expr[":"],
		{
			"contains-ci": function(elem, i, match, array)
			{
				return (elem.textContent || elem.innerText || $(elem).text() || "").toLowerCase().indexOf((match[3] || "").toLowerCase()) >= 0;
			}
		});
    </script>
    <style>
    </style>

@stop

