@extends('Myadmin::layout.basic')

@section('header')
<script src="{{ App::make("myadmin")->asset('/ckeditor/ckeditor.js') }}"></script>
<script src="../../../js/bootstrap-datetimepicker.min.js" type="text/javascript"></script>
<link rel="stylesheet" href="{{asset('css/bootstrap-datetimepicker.min.css')}}" />
<script src="https://maps.googleapis.com/maps/api/js"></script>
<script>
    function initialize() {
        var myLatLng = {lat: parseFloat($("[name=position_x]").val()), lng: parseFloat($("[name=position_y]").val())};
        console.log(myLatLng);
        var mapCanvas = document.getElementById('map');
        var mapOptions = {
          center: myLatLng,
          zoom: 15,
          mapTypeId: google.maps.MapTypeId.ROADMAP,
          styles:[{"elementType":"geometry","stylers":[{"hue":"#ff4400"},{"saturation":-68},{"lightness":-4},{"gamma":0.72}]},{"featureType":"road","elementType":"labels.icon"},{"featureType":"landscape.man_made","elementType":"geometry","stylers":[{"hue":"#0077ff"},{"gamma":3.1}]},{"featureType":"water","stylers":[{"hue":"#00ccff"},{"gamma":0.44},{"saturation":-33}]},{"featureType":"poi.park","stylers":[{"hue":"#44ff00"},{"saturation":-23}]},{"featureType":"water","elementType":"labels.text.fill","stylers":[{"hue":"#007fff"},{"gamma":0.77},{"saturation":65},{"lightness":99}]},{"featureType":"water","elementType":"labels.text.stroke","stylers":[{"gamma":0.11},{"weight":5.6},{"saturation":99},{"hue":"#0091ff"},{"lightness":-86}]},{"featureType":"transit.line","elementType":"geometry","stylers":[{"lightness":-48},{"hue":"#ff5e00"},{"gamma":1.2},{"saturation":-23}]},{"featureType":"transit","elementType":"labels.text.stroke","stylers":[{"saturation":-64},{"hue":"#ff9100"},{"lightness":16},{"gamma":0.47},{"weight":2.7}]}]
        }
        var map = new google.maps.Map(mapCanvas, mapOptions);
        var marker = new google.maps.Marker({
            position: myLatLng,
            map: map,
            title: $("[name=address]").val()
        });
        var infowindow = new google.maps.InfoWindow({
            content: $("[name=address]").val()
        });

        marker.addListener('click', function() {
            infowindow.open(marker.get('map'), marker);
        });
    }
    google.maps.event.addDomListener(window, 'load', initialize);
</script>
@stop

@section('content')
<style type="text/css" media="screen">
      .form-group .no-padding {
         padding-top:0px;
      }
      #map {
        width: 500px;
        height: 400px;
      }
    img#preview{
        width:150px;
        height:150px;
        padding:2px;
        border:1px solid #000;
    }
	.btn-my{  
		background: #006633;
		width: 100px;  
		height: 100px;  
		-moz-border-radius: 50%;  
		-webkit-border-radius: 50%;  
		border-radius: 50%;  
	}  
	.btn-my:hover {  
        background: #BFEC3E;   
        color:#e75616;  
    }  
    .suggest-name {
        display:none;
    }
    .suggest {
        cursor:pointer;
    }

    .suggest:hover {
        color:orange;
    }
</style>
<div>
    {{ Form::model($shop, array(
		'url' => array('admin/product/shopupdate', $shop->id),
        'class'=>'form-horizontal well',
        'method' => 'get'  //put
    ))}}

	@if($errors->has())
			<div class="alert alert-warning" role="alert">{{ $errors->first() }}</div>
	@endif

    <div class="form-group ">
		<h3><label class="col-sm-2 control-label">實體店編輯 : </label></h3>
    </div>
    <div class="form-group ">
        <label class="col-sm-2 control-label">店名</label>
        <div class="col-sm-10">
            {{ Form::text('name', null, array('class' => 'form-control'))}}
        </div>
    </div>
    <div class="form-group ">
        <label class="col-sm-2 control-label">區域</label>
        <div class="col-sm-10">
            {{ Form::text('region', null, array('class' => 'form-control'))}}
        </div>
    </div>
    <div class="form-group ">
        <label class="col-sm-2 control-label">地址</label>
        <div class="col-sm-10">
            {{ Form::text('address', null, array('class' => 'form-control'))}}
        </div>
    </div>
    <div class="form-group ">
        <div class="col-sm-2 control-label suggest-name no-padding">建議</div>
        <div class="col-sm-4 suggest"></div>
    </div>
    <div class="form-group ">
        <label class="col-sm-2 control-label">經度</label>
        <div class="col-sm-10">
            {{ Form::text('position_x', null, array('class' => 'form-control'))}}
        </div>
    </div>
    <div class="form-group ">
        <label class="col-sm-2 control-label">緯度</label>
        <div class="col-sm-10">
            {{ Form::text('position_y', null, array('class' => 'form-control'))}}
        </div>
    </div>
    <div class="form-group ">
        <label class="col-sm-2 control-label">地圖</label>
        <div class="col-sm-10" id="map">
        </div>
    </div>

    <hr>
    <div class="form-group">
        <label class="col-sm-2 control-label"></label>
        <div class="col-sm-10">
            <input type="submit" id="submit_activity" value="編輯完成" class="btn btn-primary"  />
        </div>
    </div>
    {{ Form::close()}}
</div>

<script type="text/javascript">
	$(function() {
		$("#datetimepicker1,#datetimepicker2").datetimepicker({
			language: 'en',
			pickTime: 'true',
			format: 'yyyy-MM-dd hh:mm:ss'
		});
	});
</script>
<script type="text/javascript" charset="utf-8">
	$(document).ready(function(){
        $("[name=address]").bind("keyup change", function(){
            if($(this).val() == "") {
                $("[name=position_x]").val("");
                $("[name=position_y]").val("");
            }
            var obj = getLocation($(this).val());
            obj.success(function (data) {
                if(data["status"] == "OK") {
                    var format = data["results"][0]["formatted_address"];
                    $(".suggest-name").show();
                    $(".suggest").html(format);
                    var location = data["results"][0]["geometry"]["location"];
                    $("[name=position_x]").val(location["lat"]);
                    $("[name=position_y]").val(location["lng"]);
    

                    var mapID = 'gray';
                    var map = new google.maps.Map(document.getElementById('map'),{
                        mapTypeControlOptions: {
                            mapTypeIds: [google.maps.MapTypeId.ROADMAP, mapID]
                        }
                    });
                    map.setZoom(13); 
                    var styleMap = new google.maps.StyledMapType([{"elementType":"geometry","stylers":[{"hue":"#ff4400"},{"saturation":-68},{"lightness":-4},{"gamma":0.72}]},{"featureType":"road","elementType":"labels.icon"},{"featureType":"landscape.man_made","elementType":"geometry","stylers":[{"hue":"#0077ff"},{"gamma":3.1}]},{"featureType":"water","stylers":[{"hue":"#00ccff"},{"gamma":0.44},{"saturation":-33}]},{"featureType":"poi.park","stylers":[{"hue":"#44ff00"},{"saturation":-23}]},{"featureType":"water","elementType":"labels.text.fill","stylers":[{"hue":"#007fff"},{"gamma":0.77},{"saturation":65},{"lightness":99}]},{"featureType":"water","elementType":"labels.text.stroke","stylers":[{"gamma":0.11},{"weight":5.6},{"saturation":99},{"hue":"#0091ff"},{"lightness":-86}]},{"featureType":"transit.line","elementType":"geometry","stylers":[{"lightness":-48},{"hue":"#ff5e00"},{"gamma":1.2},{"saturation":-23}]},{"featureType":"transit","elementType":"labels.text.stroke","stylers":[{"saturation":-64},{"hue":"#ff9100"},{"lightness":16},{"gamma":0.47},{"weight":2.7}]}], {name: "styled map"});
                    map.mapTypes.set(mapID, styleMap);
                    map.setMapTypeId(mapID);
                    map.setCenter(location);
                    var marker = new google.maps.Marker({
                        map: map,
                        position: location
                    });

                    var infowindow = new google.maps.InfoWindow({
                        content: $("[name=address]").val()
                    });

                    marker.addListener('click', function() {
                        infowindow.open(marker.get('map'), marker);
                    });
                } else {
                    $(".suggest-name").hide();
                }
            });
        });

        $(".suggest").click(function(){
            $("[name=address]").val($(".suggest").html());
        });
	});
	
</script>
@stop

@section('js-snippet')
    @include('Myadmin::js.preview', array('bind' => 'input[name=image]','target' => '#preview'))
    @include('Myadmin::js.ckeditor', array(
        'target' => 'origin_content',
    ))
@stop
