@extends('Myadmin::layout.basic')

@section('content')
<style type="text/css" media="screen">
	.btn-custom{  
		width: 150px;  
    } 

    .table-btn td{
        padding:10px;
    }
</style>

    <div class="input-prepend input-append">
    </div>
    <h4 class="nametag">{{{ trans($_CONST["LANG_DEST"].".title")}}}</h4>
	<br><br><br>
    {{ Form::open(array(  'class'=>'form-horizontal well'))}}
    <div class="input-group">
        <span class="input-group-addon">{{{ trans($_CONST["LANG_DEST"].".select_class")}}}：</span>
        {{ Form::select('id', $categories, $cid, array('class' => 'form-control') )}}
    </div>
    {{ Form::close()}}
	<hr>

		<div class="row">	
            <div class="col-xs-8 col-sm-8 col-md-8">
                <table class="table-btn">
                    <tr><td>
                    <a href="{{ route($_CONST["CONTROLLER_ROUTE"].'.create', 'category='.$cid)}}" class="btn btn-primary btn-custom" style="margin-top:10px">
                        <span class="glyphicon glyphicon-file"></span>
                            新增
                    </a>
                    </td></tr>
                </table>
			</div>

			<div class="col-md-4 col-sm-4 col-xs-4 pull-right" style="margin-top:10px">
				<div class="input-group">
					<input type="text" class="form-control" placeholder="Product's name" id="search_input">
					<span class="input-group-btn">
						<button class="btn btn-default" type="button" name="search">Seach</button>
					</span>
				</div>
			</div>

		</div>
		<hr>

    <table class="table table-bordered" id="product-table">
		<thead>
			<tr><th>發佈</th><th>商品ID</th><th>品名</th><th>分類</th><th>規格選擇</th><th>原價</th><th>特價</th><th style="width:100px">官網網址</th><th style="width:180px">功能按鈕</th></tr>
		</thead>
		<tbody>
        @foreach ($products as $product) 
        <tr data-id={{$product->id}} >
			@if ($product->publish == 1)
	            <td style="width:129px font-size:12px">yes</td>
			@else
	            <td style="width:129px font-size:12px">no</td>
			@endif
            <td style="width:129px font-size:12px">{{ $product->id }}</td>
            <td style="width:129px font-size:12px" id="td_pro_title">{{ $product->title }}</td>
            <td style="width:129px font-size:12px">{{ $categories[$product->category_id] }}</td>
            <td style="width:129px font-size:12px">{{ $product->format }}</td>
		    <td style="width:100px font-size:12px">{{ $product->price }}</td>
            <td style="width:129px font-size:12px">{{ $product->selling_price }}</td>
            <td style="width:150px font-size:12px">{{ $product->official_url }}</td>

            <td style="width:100px font-size:12px">
                {{ Form::open(array(
                    'route'=>array('admin.product.destroy', $product->id),
                    'method' => 'delete')
                )}}
                <a href="{{ route('admin.product.edit', $product->id)}}" class="btn btn-primary">
                    <span class="glyphicon glyphicon-pencil"></span>
                    編輯
                </a>

                <a href="#" onclick="if (confirm('{{ trans('Myadmin::layout.whether_to_delete')}}'))$(this).closest('form').submit()" class="btn btn-danger">
                    <span class="glyphicon glyphicon-remove"></span>
                    刪除
                </a>
                {{ Form::close()}}
            </td>

        </tr>
        @endforeach
		<input type="hidden" value="" class="id-change"></input>
		</tbody>
    </table>


    <script type="text/javascript" charset="utf-8">
        $(document).ready(function(){
            var base_url = "{{route('admin.product.index')}}";
			var c_array = [];
			var unique;

            $("#search").click(function(){
                var redirect = base_url+'/'+$("input[name=search]").val();
                window.location.href = redirect;
            });

            $("select[name=id]").change(function(){
                var t = $("select[name=id]").val();
                var base_url = "{{ route($_CONST["CONTROLLER_ROUTE"].".index")}}";
                if (t==0) {
                    var target = base_url;
                }else {
                    var target = base_url + '/' + t;
                }
                window.location = target;
            });

			$("#search_input").keyup(function(){
				// When value of the input is not blank
				if( $(this).val() != ""){
				// Show only matching TR, hide rest of them
			 		$("#product-table tbody>tr").hide();
					$("#product-table #td_pro_title:contains-ci('"+$(this).val()+"')").parent("tr").show();
		 		}
		 		else{
			 		// When there is no input or clean again, show everything back
			 		$("#product-table tbody>tr").show();
		 		}
			});

        });

		$.extend($.expr[":"],
		{
			"contains-ci": function(elem, i, match, array)
			{
				return (elem.textContent || elem.innerText || $(elem).text() || "").toLowerCase().indexOf((match[3] || "").toLowerCase()) >= 0;
			}
		});
    </script>

@stop
