<?php

class MyadminSliderController extends \BaseController {

    protected $layout = 'Myadmin::layout.basic';

    public function __construct()
    {
        $routeName = Route::currentRouteName();
        $routeName = substr($routeName, 0, strrpos($routeName, '.'));
        $routeAction = Route::currentRouteAction();
        $routeAction = substr($routeAction, 0, strrpos($routeAction, '@'));

        $this->_CONST = array();
        $this->_CONST["CONTROLLER_ROUTE"] = $routeName;
        $this->_CONST["CONTROLLER_ACTION"] = $routeAction;
    }

    /**
     * Display a listing of the resource.
     *
     * @return Response
     */
    public function index()
    {
        $this->layout->content = View::make('slider::index')
            ->with('_CONST', $this->_CONST)
            ->withSliders(MyadminSlider::all());
    }


    /**
     * Show the form for creating a new resource.
     *
     * @return Response
     */
    public function create()
    {
        $this->layout->content = View::make('slider::create')
            ->with('_CONST', $this->_CONST);
    }


    /**
     * Store a newly created resource in storage.
     *
     * @return Response
     */
    public function store()
    {
        $userInput = Input::all();
        $slider = new MyadminSlider;
        $slider->title = $userInput['title'];
        if (Input::hasFile('image')) {
            $dest = img_upload_path();
            $file = Input::file('image');
            $originalName = md5(time());
            $file->move($dest, $originalName.'.'.$file->getClientOriginalExtension());

            $slider->img_path = img_upload_path_prefix().$originalName.'.'.$file->getClientOriginalExtension();
        }

        $slider->save();
        return Redirect::route($this->_CONST["CONTROLLER_ROUTE"].'.index');
    }


    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return Response
     */
    public function show($id)
    {
    }


    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return Response
     */
    public function edit($id)
    {
        $this->layout->content = View::make('slider::edit')
            ->with('_CONST', $this->_CONST)
            ->withSlider(MyadminSlider::findOrFail($id));
    }


    /**
     * Update the specified resource in storage.
     *
     * @param  int  $id
     * @return Response
     */
    public function update($id)
    {
        $userInput = Input::all();
        $validator = Validator::make(
            $userInput,
            array(
                'title' => 'required',
                'image' => 'required|image'
            )
        );
        if ($validator->passes()) {
            $slider = MyadminSlider::findOrFail($id);
            $slider->title = $userInput['title'];
            img_test_and_remove($slider->img_path);
            if (Input::hasFile('image')) {
                $dest = img_upload_path();
                $file = Input::file('image');
                $originalName = md5(time());
                $file->move($dest, $originalName.'.'.$file->getClientOriginalExtension());

                $slider->img_path = img_upload_path_prefix().$originalName.'.'.$file->getClientOriginalExtension();
            }

            $slider->save();
            return Redirect::route($this->_CONST["CONTROLLER_ROUTE"].'.index');
        }
        return Redirect::route($this->_CONST["CONTROLLER_ROUTE"].'.create')->withErrors($validator);
    }


    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return Response
     */
    public function destroy($id)
    {
        $slider = MyadminSlider::findOrFail($id);
        $slider->delete();
        img_test_and_remove($slider->img_path);
        return Redirect::route($this->_CONST["CONTROLLER_ROUTE"].'.index');
    }

}
