@extends('Myadmin::layout.basic')

@section('header')
<style type="text/css" media="screen">
    table img{
        max-width:500px;
    }
</style>
@stop

@section('content')
<div class="row-fluid">
    <div class="span9">
        <h4 class="nametag">Slider系統</h4>
        <a href="{{ route($_CONST["CONTROLLER_ROUTE"].'.create')}}" class="btn btn-primary">
            <span class="glyphicon glyphicon-file"></span>
            新增Slider
        </a>
        <hr>
        <table class="table table-bordered">
            <tr>
                <th>說明</th>
                <th>圖片</th>
                <th>更新時間</th>
                <th>操作</th>
            </tr>
@foreach($sliders as $slider)
            <tr>
                <th>{{{ $slider->title}}}</th>
                <th><img src="{{{ img_upload_url($slider->img_path)}}}"></th>
                <th>{{{ $slider->updated_at}}}</th>
                <th>
                    {{ Form::open(array(
                        'route'=>array($_CONST["CONTROLLER_ROUTE"].'.destroy', $slider->id),
                        'method' => 'delete')
                    )}}
                    <a href="{{ route($_CONST["CONTROLLER_ROUTE"].'.edit', $slider->id)}}" class="btn btn-primary">
                        <span class="glyphicon glyphicon-pencil"></span>
                        修改
                    </a>
                    <a href="#" onclick="if (confirm('{{ trans('Myadmin::layout.whether_to_delete')}}'))$(this).closest('form').submit()" class="btn btn-danger">
                        <span class="glyphicon glyphicon-trash"></span>
                        刪除
                    </a>
                    {{ Form::close()}}
                </th>
            </tr>
@endforeach
        </table>
    </div>
</div>
@stop
