@extends('Myadmin::layout.basic')

@section('content')
<div class="row-fluid">
    <div class="span9">
        <h4 class="nametag">{{{ trans($_CONST["LANG_DEST"].".title")}}}</h4>
        <a href="{{ route($_CONST["CONTROLLER_ROUTE"].'.create', "category=".$cid)}}" class="btn btn-primary">
            <span class="glyphicon glyphicon-file"></span>
            {{{ trans($_CONST["LANG_DEST"].".create_action")}}}
        </a>
        <a href="{{ action($_CONST["CLASS_CONTROLLER"].'@index')}}" class="btn btn-success">
            <span class="glyphicon glyphicon-th-list"></span>
            {{{ trans($_CONST["LANG_DEST"].".browse_class")}}}
        </a>
        <hr>
        {{ Form::open(array(  'class'=>'form-horizontal well'))}}
        <div class="input-group">
            <span class="input-group-addon">{{{ trans($_CONST["LANG_DEST"].".select_class")}}}：</span>
            {{ Form::select('id', $categories, null, array('class' => 'form-control') )}}
        </div>
        {{ Form::close()}}
        <table class="table table-bordered">
            <tr>
                <th>標題</th>
                <th>類別</th>
                <th>更新時間</th>
                <th>操作</th>
            </tr>
            @foreach ($articles as $article)
            <tr>
                <td>{{{ $article->title}}}</td>
                <td>
                    <a href="{{ route($_CONST["CONTROLLER_ROUTE"].'.show', $article->category->id)}}">
                        {{{ $article->category->title}}}
                    </a>
                </td>
                <td>{{{ $article->updated_at}}}</td>
                <td>
                    {{ Form::open(array(
                        'route'=>array($_CONST["CONTROLLER_ROUTE"].'.destroy', $article->id),
                        'method' => 'delete',
'class' => 'form-inline delete',
                        )
                    )}}
                    <a href="{{ route($_CONST["CONTROLLER_ROUTE"].'.edit', $article->id)}}" class="btn btn-primary">
                        <span class="glyphicon glyphicon-pencil"></span>
                        {{{ trans($_CONST["LANG_DEST"].".edit_action")}}}
                    </a>
                    <a href="{{ route($_CONST["CONTROLLER_ROUTE"].'.edit', $article->id)}}" class="btn btn-primary">
                        <span class="glyphicon glyphicon-eye-open"></span>
                        {{{ trans($_CONST["LANG_DEST"].".browse_action")}}}
                    </a>
                    <a href="#" onclick="if (confirm('{{ trans('Myadmin::layout.whether_to_delete')}}'))$(this).closest('form').submit()" class="btn btn-danger">
                        <span class="glyphicon glyphicon-trash"></span>
                        {{trans($_CONST["LANG_DEST"].".delete_action")}}
                    </a>
                    {{ Form::close()}}
                </td>
            </tr>
            @endforeach
        </table>
    </div>
<script type="text/javascript" charset="utf-8">
    $(document).change(function(){
        var t = $("select[name=id]").val();
        var base_url = "{{ route($_CONST["CONTROLLER_ROUTE"].".index")}}";
        var target = base_url + '/' + t;
        console.log(target);
        window.location = target;
    });
</script>
</div>
@stop
