<?php

class MyadminUserClassController extends \BaseController {

    protected $layout = 'Myadmin::layout.basic';

    public function __construct()
    {
        $routeName = Route::currentRouteName();
        $routeName = substr($routeName, 0, strrpos($routeName, '.'));
        $level = \Session::get('level');
        $operators = \OperatorLog::getLogList();
	$routeAction = Route::currentRouteAction();
        $routeAction = substr($routeAction, 0, strrpos($routeAction, '@'));

        $this->_CONST = array();
	$this->_CONST['CONTROLLER_ACTION'] = $routeAction;
        $this->_CONST["CONTROLLER_ROUTE"] = $routeName;
        $this->_CONST["SUB_CONTROLLER"] = $this->getSubController();
        $this->_CONST["LANG_DEST"] = $this->getLangDest(); // interface function
        $this->_CONST["level"] = $level;
        $this->_CONST["operators"] = $operators;

//        $this->articleModelInstance = $this->getUserInstance();
        //$this->articleClassModelInstance = $this->getUserClassInstance();
    
    }
    /**
     * Display a listing of the resource.
     *
     * @return Response
     */
    public function index()
    {
	$categories = DB::table('blogger_classes')->get();	
        return View::make('user-management::class.index')
            ->with('_CONST', $this->_CONST)
            ->withCategories($categories);
  //          ->withArticles($this->articleModelInstance->all());
    }


    /**
     * Show the form for creating a new resource.
     *
     * @return Response
     */
    public function create()
    {
        //
    }


    /**
     * Store a newly created resource in storage.
     *
     * @return Response
     */
    public function store()
    {
        $userInput = Input::all();
        //$class = $this->articleClassModelInstance->create(array('title' => $userInput['title']));
        //$class->is_available = 1;
        //$class->save();
	
	DB::table('blogger_classes')->insert(array(array(
			'title'=>$userInput['title'],
			'is_available' => 1)
		));
        return Redirect::route($this->_CONST["CONTROLLER_ROUTE"].'.index');
    }


    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return Response
     */
    public function show($id)
    {
//        $category = $this->articleModelInstance->findOrFail($id);
//        $articles = $category->articles;
	$categories = DB::table('blogger_classes')->get();	
        return View::make('user-management::class.show')
            ->with('_CONST', $this->_CONST)
//            ->withCurrent($category)
            ->withCategories($categories);
//            ->withArticles($articles);
    }


    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return Response
     */
    public function edit($id)
    {
        //
    }


    /**
     * Update the specified resource in storage.
     *
     * @param  int  $id
     * @return Response
     */
    public function update($id)
    {
        $userInput = Input::all();
        //$class = $this->articleClassModelInstance->findOrFail($id);
       // $class->timestamps = false;
        //$class->title = $userInput["title"];
       // $class->save();
	DB::table('blogger_classes')->where('id',$id)
                           ->update(array(
                                'title'=> $userInput['title'],));

        return Redirect::route($this->_CONST["CONTROLLER_ROUTE"].'.index');
    }


    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return Response
     */
    public function destroy($id)
    {
        //$product = $this->articleClassModelInstance->findOrFail($id);
        //$product->delete();
	DB::table('blogger_classes')->where('id',$id)->delete();
        return Redirect::route($this->_CONST["CONTROLLER_ROUTE"].'.index');
    }

    public function getSubController()
    {
        // rewrite by subcontroller's name
    }

    public function getLangDest()
    {
        return "user-management::view";
    }

   public function getEnable($id)
   {
       try {
/*            $class = $this->articleClassModelInstance->findOrFail($id);
            $class->is_available = '1';
            $class->timestamps = false;
            $class->save();
*/
	DB::table('blogger_classes')->where('id',$id)
                           ->update(array(
                                'is_available'=> 1,));
	$class['title']= DB::table('blogger_classes')->where('id',$id)->select('title')->first();
	//顯示文章
	//    $visible_category = $this->articleModelInstance->where('category','=',$id)->update(array('isActive' => 1));
		
            $id = \Session::get('id');
                OperatorLog::saveItem($id, "Looker種類顯示 " . $class['title']->title);
            return Redirect::action($this->_CONST["CONTROLLER_ACTION"].'@index');
       } catch(\Illuminate\Database\Eloquent\ModelNotFoundException $e) {
            return Redirect::action($this->_CONST["CONTROLLER_ACTION"].'@index');
       }
   }
   public function getDisable($id)
   {
       try {
/*            $class = $this->articleClassModelInstance->findOrFail($id);
            $class->is_available = '0';
            $class->timestamps = false;
            $class->save();
*/
	DB::table('blogger_classes')->where('id',$id)
                           ->update(array(
                                'is_available'=> 0,));
	$class['title']= DB::table('blogger_classes')->where('id',$id)->select('title')->first();
	//停用相關文章
	//    $invisible_category = $this->articleModelInstance->where('category','=',$id)->update(array('isActive' => 0));

            $id = \Session::get('id');
                OperatorLog::saveItem($id, "looker種類隱藏 " . $class['title']->title);
            return Redirect::action($this->_CONST["CONTROLLER_ACTION"].'@index');
       } catch(\Illuminate\Database\Eloquent\ModelNotFoundException $e) {
            return Redirect::action($this->_CONST["CONTROLLER_ACTION"].'@index');
       }
   }
}
