<?php

class MyadminUserController extends \BaseController {

    protected $layout = 'Myadmin::layout.basic';
    protected $_CONST;

    public function __construct()
    {
        $routeName = Route::currentRouteName();
        $routeName = substr($routeName, 0, strrpos($routeName, '.'));
        $routeAction = Route::currentRouteAction();
        $routeAction = substr($routeAction, 0, strrpos($routeAction, '@'));

        $level = \Session::get('level');
        $operators = \OperatorLog::getLogList();
        
        $this->_CONST = array();
        $this->_CONST["CONTROLLER_ROUTE"] = $routeName;
        $this->_CONST["CONTROLLER_ACTION"] = $routeAction;
        $this->_CONST["level"] = $level;
        $this->_CONST["operators"] = $operators;
           
    }

    /**
     * Display a listing of the resource.
     *
     * @return Response
     */
    public function index()
    {
       // $this->layout->content =
	/*return  View::make('user-management::user.index')
            	->with('_CONST', $this->_CONST)
            	->withUsers(MyadminUser::paginate(15));*/

	$bloggers = array();
	if(isset($_GET['category']))
        $bloggers = DB::table('bloggers')->where('category',$_GET['category'])->get();
	else
		$bloggers = DB::table('bloggers')->get();
	
	$object ="ARTICLE";
	foreach($bloggers as $blogger)
	{
		$like_num = DB::table('action_log')->where('object',$object)->where('object_id',$blogger->id)->where('action','LIKE')->count();
        DB::table('bloggers')->where('id',$blogger->id)->update(array('like_num'=>$like_num));
	}

	$bloggers = array();
	if(isset($_GET['category']))
        $bloggers = DB::table('bloggers')->where('category',$_GET['category'])->get();
	else
		$bloggers = DB::table('bloggers')->get();
	
	return  View::make('user-management::blogger.blogger')
            	->with('_CONST', $this->_CONST)
            	->withBloggers($bloggers);
    }


    /**
     * Show the form for creating a new resource.
     *
     * @return Response
     */
    public function create()
    {
        //$this->layout->content = 
	return View::make('user-management::blogger.create')
	            ->with('_CONST', $this->_CONST);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @return Response
     */
    public function store()
    {
        $userInput = Input::all();
        $validator = Validator::make(
            $userInput,
            array(
                'name' => 'required|unique:bloggers,name',
            )
        );
        if ($validator->fails()) {
            Input::flashExcept('password');
            return Redirect::route($this->_CONST["CONTROLLER_ROUTE"].'.create')->withErrors($validator->messages());
        }else{
            $user = MyadminUser::firstOrCreate(array('name' => $userInput['name']));
            $user->name = $userInput["name"];
            $user->description = $userInput["description"];
            $user->Facebook_url = $userInput["Facebook_url"];
            $user->Instagram_url =$userInput["Instagram_url"];
            $user->Youtube_url =$userInput["Youtube_url"];
            $user->buy_now =$userInput["buy_now"];
            $user->location =$userInput["location"];
            $user->website =$userInput["website"];
            $user->isActive = $userInput["publish"];
	    $isBuy = isset($userInput["visible_buy"])?"1" : "0";
	    $isLocate = isset($userInput["visible_location"])?"1" : "0";
	    $isShowWeb = isset($userInput["visible_web"])?"1" : "0";
            $user->isBuy = $isBuy;
            $user->isLocate = $isLocate;
            $user->isShowWeb = $isShowWeb;
	    if(Input::hasFile('photo'))
	    {
		$dest = img_upload_path();
		$file = Input::file('photo');
                $originalName = md5(time());
                                        $r = rand(1,999);
                                        $originalName = $originalName.$r;
                $file->move($dest, $originalName.$file->getClientOriginalExtension());
                //$file->move($dest, $originalName.$file->getClientOriginalName());
                $user->photo =img_upload_path_prefix().$originalName.$file->getClientOriginalExtension();
	    }
            if(Input::hasFile('image'))
            {
                $dest = img_upload_path();
                $file = Input::file('image');
                $originalName = md5(time());
                                        $r = rand(1,999);
                                        $originalName = $originalName.$r;
                $file->move($dest, $originalName.$file->getClientOriginalExtension());
                //$file->move($dest, $originalName.$file->getClientOriginalName());
                $user->image =img_upload_path_prefix().$originalName.$file->getClientOriginalExtension();
            }
            $user->save();
            $id = \Session::get('id');
            OperatorLog::saveItem($id, "新增部落客 " . $userInput['name']);
            return Redirect::route($this->_CONST["CONTROLLER_ROUTE"].'.index');
        }
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return Response
     */
    public function edit($id)
    {
        $user = MyadminUser::findOrFail($id);
	$url = img_upload_path_prefix();
//        $this->layout->content =
	return  View::make('user-management::blogger.edit')
	            ->with('_CONST', $this->_CONST)
        	    ->withUser($user)
		    ->withUrl($url);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  int  $id
     * @return Response
     */
    public function update($id)
    {
        $validator = $this->userValidator(Input::all());
        if ($validator->fails()) {
            Input::flashExcept('password');
            return Redirect::route($this->_CONST["CONTROLLER_ROUTE"].'.edit', $id)->withErrors($validator->messages());
        }else{
            $userInput = Input::all();
            $user = MyadminUser::findOrFail($id);
            $user->name = $userInput["name"];
            $user->description = $userInput["description"];
            $user->Facebook_url = $userInput["Facebook_url"];
            $user->Instagram_url = $userInput["Instagram_url"];
            $user->Youtube_url = $userInput["Youtube_url"];
	    if(Input::has('publish'))
	            $user->isActive = $userInput["publish"];


	    $user->location =$userInput["location"];
            $user->website =$userInput["website"];
            $user->isActive = $userInput["publish"];
            $isBuy = isset($userInput["visible_buy"])?"1" : "0";
            $isLocate = isset($userInput["visible_location"])?"1" : "0";
            $isShowWeb = isset($userInput["visible_web"])?"1" : "0";
            $user->isBuy = $isBuy;
            $user->isLocate = $isLocate;
            $user->isShowWeb = $isShowWeb;

	    if(Input::hasFile('photo'))
            {
                $dest = img_upload_path();
                $file = Input::file('photo');
		$originalName = md5(time());
                                        $r = rand(1,999);
                                        $originalName = $originalName.$r;
                $file->move($dest, $originalName.$file->getClientOriginalExtension());
                //$file->move($dest, $originalName.$file->getClientOriginalName());
                $user->photo =img_upload_path_prefix().$originalName.$file->getClientOriginalExtension();
            }
            if(Input::hasFile('image'))
            {
                $dest = img_upload_path();
                $file = Input::file('image');
                $originalName = md5(time());
                                        $r = rand(1,999);
                                        $originalName = $originalName.$r;
                $file->move($dest, $originalName.$file->getClientOriginalExtension());
                //$file->move($dest, $originalName.$file->getClientOriginalName());
                $user->image =img_upload_path_prefix().$originalName.$file->getClientOriginalExtension();
            }

            $user->save();
            $id = \Session::get('id');
            OperatorLog::saveItem($id, "編輯部落客 " . $userInput['name']);
            return Redirect::route($this->_CONST["CONTROLLER_ROUTE"].'.index');
        }
    }

    public function getEnable($id)
    {
        $user = MyadminUser::findOrFail($id);
        $user->isActive = True;
        $user->save();
        $id = \Session::get('id');
        OperatorLog::saveItem($id, "開通部落客權限 " . $user['name']);
        return Redirect::action($this->_CONST["CONTROLLER_ACTION"].'@index');
    }

    public function getDisable($id)
    {
        $user = MyadminUser::findOrFail($id);
        $user->isActive = False;
        $user->save();
        $id = \Session::get('id');
        OperatorLog::saveItem($id, "停權部落客 " . $user['name']);
        return Redirect::action($this->_CONST["CONTROLLER_ACTION"].'@index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return Response
     */
    public function destroy($id)
    {
        $user = MyadminUser::findOrFail($id);
        $user->delete();
        return Redirect::action($this->_CONST["CONTROLLER_ACTION"].'@index');
    }

    private function userValidator($input)
    {
        return Validator::make(
            $input,
            array(
                'name' => 'required',
                //'email' => 'required',
                //'permission' => 'required',
            )
        );
    }

}
