<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateUserTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
    {
        $self_table_name = 'myadmin_users';
        if(!Schema::hasTable($self_table_name)) {
            Schema::create($self_table_name, function($table){
                $table->increments('id');
                $table->string('account', 20);
                $table->string('password', 60);
                $table->string('name', 50)->nullable();
                $table->string('email', 100)->nullable();
                $table->string('phone', 20)->nullable();
                $table->enum('permission', array( '管理員', '文章編輯者', '精油愛好者'))->default('精油愛好者');
                $table->string('remember_token', 100)->nullable();
                $table->timestamps('updated_at');
                $table->boolean('isActive')->default(True);
                $table->string('auth_code', 32)->nullable();
                $table->string('reset_code', 32)->nullable();
                $table->string('onetime_nonce', 32)->nullable();
            });
        }
        
        if(!Schema::hasTable('bloggers')) {
            Schema::create('bloggers', function($table){
                $table->increments('id');
                $table->string('category', 250)->default('Looker');
                $table->string('name', 250)->nullable();
                $table->string('description', 500)->nullable();
                $table->string('Facebook_url', 250)->nullable();
                $table->string('Instagram_url', 250)->nullable();
                $table->string('Youtube_url', 250)->nullable();
                $table->string('photo', 250)->nullable();
                $table->string('image', 250)->nullable();
                $table->string('buy_now', 250)->nullable();
    	        $table->string('location', 250)->nullable();
                $table->string('website', 250)->nullable();
                $table->string('like_num', 250)->default(0);
                $table->string('follow_num', 250)->default(0);
                $table->string('post_num', 250)->default(0);
                $table->boolean('isActive')->default(True);
                $table->boolean('isBuy')->default(False);
                $table->boolean('isLocate')->default(False);
                $table->boolean('isShowWeb')->default(False);
           // $table->timestamps('created_at');
            $table->timestamps('updated_at');
            $table->string('auth_code', 32)->nullable();
            $table->string('reset_code', 32)->nullable();
            $table->string('onetime_nonce', 32)->nullable();
        });

        }

	if(!Schema::hasTable('blogger_classes')){
       		Schema::create('blogger_classes', function($table){
	            $table->increments('id');
        	    $table->string('title', 100);
	            $table->boolean('is_available');
        	});
	}

	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
        Schema::drop('myadmin_users');
        Schema::drop('bloggers');
        Schema::drop('blogger_classes');
	}

}
