<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateLikeTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
    {
        if(!Schema::hasTable('myadmin_blogger_like')) {
            Schema::create('myadmin_blogger_like', function($table){
                $table->increments('id');
                $table->integer('user_id')->unsigned()->nullable();
                $table->integer('blogger_id')->unsigned()->nullable();
                $table->timestamps();

                $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
                $table->foreign('blogger_id')->references('id')->on('bloggers')->onDelete('cascade');
            });
        }
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
        Schema::drop('myadmin_blogger_like');
	}

}
