@extends('Myadmin::layout.basic')

@section('header')
    <style>
        #header {
            background:#8d1c22;
        }

        .form-inline {
            margin:10px;
        }
        #content .table {
            font-size:12px;
        }

        .head-table {
            width:100%;
        }
    </style>
@stop
@section('content')
   <div class="row-fluid">
        <div class="span9">
        </div>
        <div>
            <h4 class="nametag">部落客管理系統</h4>
        <a href="{{ route($_CONST["CONTROLLER_ROUTE"].'.create')}}" class="btn btn-primary"><span class="glyphicon glyphicon-user" aria-hidden="true"></span>新增部落客</a>
        <a href="{{ URL::to('admin/userclass')}}" class="btn btn-success"><span class="glyphicon glyphicon-list" aria-hidden="true"></span>部落客分類</a>
	<hr>
                <br><br><br>
	<h5>{{Session::get('message')}}</h5>

    <div>
        <table class="table table-bordered">
            <tr><th>發佈</th><th>部落客ID</th><th>部落客名稱</th><th>部落客簡介</th><th>部落客FB</th><th>部落客IG</th><th>部落客照片</th><th>按讚數</th><th>FOLLOW 數</th><th>操作</th></tr>
            @foreach ($bloggers as $blogger)
            <tr>
                <td>
                    @if($blogger->isActive)
                    <a href="{{ action($_CONST["CONTROLLER_ACTION"].'@getDisable', $blogger->id)}}" class="btn btn-success" ><i class="icon-ok-circle"></i>啟用中</a>
                    @else
                    <a href="{{ action($_CONST["CONTROLLER_ACTION"].'@getEnable', $blogger->id)}}" class="btn btn-danger"><i class="icon-ban-circle"></i>停用中</a>
                    @endif
                </td>
                <td>{{{ $blogger->id}}}</td>
                <td>{{{ $blogger->name}}}</td>
                <td>{{{ $blogger->description}}}</td>
                <td>{{{ $blogger->Facebook_url}}}</td>
                <td>{{{ $blogger->Instagram_url}}}</td>
        <td> {{ HTML::image($blogger->photo,"",['style'=>'width:100px;height:100px']) }}</td>
                <td>{{{ $blogger->like_num}}}</td>
                @if($blogger->follow_num == 0)
                <td>{{{ $blogger->follow_num}}}</td>
                @else
                <td><a href={{URL::to('admin/home/follow/'. $blogger->id)}}>{{{ $blogger->follow_num}}}</a></td>
                @endif
                <td>
                    <a href="{{ route($_CONST["CONTROLLER_ROUTE"].'.edit', $blogger->id)}}" class="btn btn-primary"><span class="glyphicon glyphicon-pencil" aria-hidden="true"></span></a>
                    {{ Form::open(array('route'=>array($_CONST["CONTROLLER_ROUTE"].'.destroy', $blogger->id),
                        'method' => 'delete','style'=>'display:inline', 'id'=>$blogger->id)
                    )}}
			<a class ="delete btn btn-large btn-danger" href="javascript:document.getElementById({{$blogger->id}}).submit();" ><span class="glyphicon glyphicon-trash"     aria-hidden="true"></span></a>
                    {{ Form::close()}}
                </td>
            </tr>
            @endforeach
        </table>
    </div>

    </div> <!-- div -->
</div> <!-- .row-fluid -->
@stop
