@extends('Myadmin::layout.basic')

@section('header')
<link rel="stylesheet" href="{{asset('public/jquery-ui/jquery-ui.theme.min.css')}}" />
<script src="{{asset('public/jquery-ui/jquery-ui.min.js')}}"></script>
<script>
$(function() {
    $( ".sortable" ).sortable({
        placeholder: "ui-state-highlight"
    });
    $( ".sortable" ).disableSelection();
});

</script>
@stop

@section('content')
<div class="row-fluid">
    <div class="span3">
        <div class="well sidebar-nav">
            <ul class="nav nav-list">
                <li class="nav-header">分類列表</li>
                @foreach ($categories as $category)
                @if ($current->id == $category->id)
                <li class="active"><a href="{{{ route($_CONST["CONTROLLER_ROUTE"].'.show', $category->id)}}}">{{{ $category->title}}}</a></li>
                @else
                <li><a href="{{{ route($_CONST["CONTROLLER_ROUTE"].'.show', $category->id)}}}">{{{ $category->title}}}</a></li>
                @endif
                @endforeach
            </ul>
        </div>
    </div>
    <div class="span9">
        <h4>{{{ $current->title}}}</h4>
        <a href="{{ route($_CONST["CONTROLLER_ROUTE"].'.create', array('category' => $current->id))}}" class="btn btn-primary">新增文章</a>
        <hr>
        <table class="table table-bordered">
            <tr>
                <th>ID</th>
                <th>標題</th>
                <th>更新時間</th>
                <th>操作</th>
                <th>刪除</th>
            </tr>
            <tbody class="sortable">
                @foreach ($articles as $article)
                <tr>
                    <td>{{{ $article->id}}}</td>
                    <td>{{{ $article->title}}}</td>
                    <td>{{{ $article->updated_at}}}</td>
                    <td>
                        <a href="{{ route($_CONST["CONTROLLER_ROUTE"].'.edit', $article->id)}}" class="btn btn-primary">修改資料</a>
                    </td>
                    <td>
                        {{ Form::open(array(
                            'route'=>array($_CONST["CONTROLLER_ROUTE"].'.destroy', $article->id),
                            'method' => 'delete')
                        )}}
                        {{ Form::submit('刪除文章', array("class"=>"delete"));}}
                        {{ Form::close()}}
                    </td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</div>
@stop
