@extends('Myadmin::layout.basic')

@section('header')
    <style>
        #header {
            background:#8d1c22;
        }

        .form-inline {
            margin:10px;
        }
        #content .table {
            font-size:12px;
        }

        .head-table {
            width:100%;
        }
    </style>
@stop
@section('content')
   <div class="row-fluid">
        <div class="span9">
        </div>
        <div>
            <h4 class="nametag">部落客管理系統</h4>
                <br><br><br>
	<h5>{{Session::get('message')}}</h5>

    <div>
        <a href="{{ route($_CONST["CONTROLLER_ROUTE"].'.create')}}" class="btn btn-primary">新增</a>
        <table class="table table-bordered">
            <tr><th>發佈</th><th>部落客ID</th><th>部落客名稱</th><th>部落客簡介</th><th>部落客FB</th><th>部落客IG</th><th>部落客照片</th><th>按讚數</th><th>FOLLOW 數</th><th>操作</th></tr>
            @foreach ($bloggers as $blogger)
            <tr>
                <td>{{ Form::checkbox('publish', 'yes');}}</td>
                <td>{{{ $blogger->id}}}</td>
                <td>{{{ $blogger->name}}}</td>
                <td>{{{ $blogger->description}}}</td>
                <td>
                    <a href="{{ action($_CONST["CONTROLLER_ACTION"].'@getDisable', $blogger->id)}}" class="btn btn-success" ><i class="icon-ok-circle"></i>啟用中</a>
                </td>
                <td>
                    @if($blogger->isActive)
                    <a href="{{ action($_CONST["CONTROLLER_ACTION"].'@getDisable', $blogger->id)}}" class="btn btn-success" ><i class="icon-ok-circle"></i>啟用中</a>
                    @else
                    <a href="{{ action($_CONST["CONTROLLER_ACTION"].'@getEnable', $blogger->id)}}" class="btn btn-danger"><i class="icon-ban-circle"></i>停用中</a>
                    @endif
                </td>
		<td>{{{ $blogger->photo}}}</td>
                <td>{{{ $blogger->like_num}}}</td>
                <td>{{{ $blogger->follow_num}}}</td>
                <td>
                    <a href="{{ route($_CONST["CONTROLLER_ROUTE"].'.edit', $blogger->id)}}" class="btn btn-primary">修改</a>
                    {{ Form::open(array('route'=>array($_CONST["CONTROLLER_ROUTE"].'.destroy', $blogger->id),
                        'method' => 'delete','style'=>'display:inline')
                    )}}
                    {{ Form::submit('刪除', array("class"=>"delete btn btn-large btn-danger"));}}
                    {{ Form::close()}}
                </td>
            </tr>
            @endforeach
        </table>
    </div>

    </div> <!-- div -->
</div> <!-- .row-fluid -->
@stop
