@extends('Myadmin::layout.basic')

@section('header')
    <style>
        #header {
            background:#8d1c22;
        }

        .form-inline {
            margin:10px;
        }
        #content .table {
            font-size:12px;
        }

        .head-table {
            width:100%;
        }
    </style>
@stop
@section('content')
   <div class="row-fluid">
        <div class="span9">
        </div>
        <div>
            <h4 class="nametag">部落客管理系統</h4>
                <br><br><br>
	<h5>{{Session::get('message')}}</h5>

    <div>
        <a href="{{ route($_CONST["CONTROLLER_ROUTE"].'.create')}}" class="btn btn-primary">新增</a>
        <table class="table table-bordered">
            <tr><th>身份</th><th>帳號</th><th>姓名</th><th>操作</th><th>啟用</th><th>刪除</th></tr>
            @foreach ($users as $user)
            <tr>
                <td>{{{ $user->permission}}}</td>
                <td>{{{ $user->account}}}</td>
                <td>{{{ $user->name}}}</td>
                <td>
                    <a href="{{ route($_CONST["CONTROLLER_ROUTE"].'.edit', $user->id)}}" class="btn btn-primary">修改資料</a>
                </td>
                <td>
                    @if($user->isActive)
                    <a href="{{ action($_CONST["CONTROLLER_ACTION"].'@getDisable', $user->id)}}" class="btn btn-success" ><i class="icon-ok-circle"></i>啟用中</a>
                    @else
                    <a href="{{ action($_CONST["CONTROLLER_ACTION"].'@getEnable', $user->id)}}" class="btn btn-danger"><i class="icon-ban-circle"></i>停用中</a>
                    @endif
                </td>
                <td>
                    {{ Form::open(array('route'=>array($_CONST["CONTROLLER_ROUTE"].'.destroy', $user->id),
                        'method' => 'delete')
                    )}}
                    {{ Form::submit('刪除帳號', array("class"=>"delete"));}}
                    {{ Form::close()}}
                </td>
            </tr>
            @endforeach
        </table>
        <div class="pagination">
            {{ $users->links()}}
        </div>
    </div>

    </div> <!-- div -->
</div> <!-- .row-fluid -->
@stop
